package edu.emory.cci.aiw.omopetl.dest.table;

import edu.emory.cci.aiw.etl.table.AbstractRecord;

/*-
 * #%L
 * AIW OMOP ETL
 * %%
 * Copyright (C) 2019 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Represents records in the provider table.
 * 
 * The provider table has the following DDL:
 * <pre>
 * CREATE TABLE OMOP.provider
(
  provider_id                   NUMBER(19)      NOT NULL ,
  provider_name                 VARCHAR(255)    NULL ,
  NPI                           VARCHAR(20)     NULL ,
  DEA                           VARCHAR(20)     NULL ,
  specialty_concept_id          INTEGER         NOT NULL ,
  care_site_id                  NUMBER(19)      NULL ,
  year_of_birth                 INTEGER         NULL ,
  gender_concept_id             INTEGER         NULL ,
  provider_source_value         VARCHAR(50)     NULL ,
  specialty_source_value        VARCHAR(50)     NULL ,
  specialty_source_concept_id   INTEGER         NOT NULL ,
  gender_source_value           VARCHAR(50)     NULL ,
  gender_source_concept_id      INTEGER         NOT NULL
)
 * </pre>
 * @author Nita
 *
 */

public class Provider extends AbstractRecord {
    
    private String providerId;
    private String providerName;
    private String npi;
    private String dea;
    private String specialtyConceptId;
    private String careSiteId;
    private String yearOfBirth;
    private String genderConceptId;
    private String providerSourceValue;
    private String specialtySourceValue;
    private String specialtySourceConceptId;
    private String genderSourceValue;
    private String genderSourceConceptId;
    
    public String getProviderId() {
        return providerId;
    }
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
    public String getProviderName() {
        return providerName;
    }
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }
    public String getNpi() {
        return npi;
    }
    public void setNpi(String npi) {
        this.npi = npi;
    }
    public String getDea() {
        return dea;
    }
    public void setDea(String dea) {
        this.dea = dea;
    }
    public String getSpecialtyConceptId() {
        return specialtyConceptId;
    }
    public void setSpecialtyConceptId(String specialtyConceptId) {
        this.specialtyConceptId = specialtyConceptId;
    }
    public String getCareSiteId() {
        return careSiteId;
    }
    public void setCareSiteId(String careSiteId) {
        this.careSiteId = careSiteId;
    }
    public String getYearOfBirth() {
        return yearOfBirth;
    }
    public void setYearOfBirth(String yearOfBirth) {
        this.yearOfBirth = yearOfBirth;
    }
    public String getGenderConceptId() {
        return genderConceptId;
    }
    public void setGenderConceptId(String genderConceptId) {
        this.genderConceptId = genderConceptId;
    }
    public String getProviderSourceValue() {
        return providerSourceValue;
    }
    public void setProviderSourceValue(String providerSourceValue) {
        this.providerSourceValue = providerSourceValue;
    }
    public String getSpecialtySourceValue() {
        return specialtySourceValue;
    }
    public void setSpecialtySourceValue(String specialtySourceValue) {
        this.specialtySourceValue = specialtySourceValue;
    }
    public String getSpecialtySourceConceptId() {
        return specialtySourceConceptId;
    }
    public void setSpecialtySourceConceptId(String specialtySourceConceptId) {
        this.specialtySourceConceptId = specialtySourceConceptId;
    }
    public String getGenderSourceValue() {
        return genderSourceValue;
    }
    public void setGenderSourceValue(String genderSourceValue) {
        this.genderSourceValue = genderSourceValue;
    }
    public String getGenderSourceConceptId() {
        return genderSourceConceptId;
    }
    public void setGenderSourceConceptId(String genderSourceConceptId) {
        this.genderSourceConceptId = genderSourceConceptId;
    }
    
    
}
