/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.CaseInsensitiveAttributeNamedPersonImpl;
import org.jasig.services.persondir.support.ldap.LdapPersonAttributeDao;
import org.jasig.services.persondir.support.ldap.LogicalFilterWrapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class LdapPersonRoleAttributeDao
extends LdapPersonAttributeDao {
    private DefaultLdapAuthoritiesPopulator ldapAuthoritiesPopulator;

    protected List<IPersonAttributes> getPeopleForQuery(LogicalFilterWrapper queryBuilder, String queryUserName) {
        List attribs = super.getPeopleForQuery(queryBuilder, queryUserName);
        ArrayList<IPersonAttributes> peopleWithRoles = new ArrayList<IPersonAttributes>(attribs.size());
        Collection authorities = null;
        try {
            String userDn = "uid=" + queryUserName + "," + this.getBaseDN();
            authorities = this.ldapAuthoritiesPopulator.getGrantedAuthorities((DirContextOperations)new DirContextAdapter(userDn), queryUserName);
        }
        catch (Exception nnfe) {
            this.logger.error((Object)"error looking up authorities", (Throwable)nnfe);
        }
        if (null != authorities) {
            ArrayList<GrantedAuthority> authoritiesList = new ArrayList<GrantedAuthority>();
            for (GrantedAuthority auth : authorities) {
                authoritiesList.add(auth);
            }
            for (IPersonAttributes person : attribs) {
                HashMap<String, ArrayList<GrantedAuthority>> attrs = new HashMap<String, ArrayList<GrantedAuthority>>();
                attrs.putAll(person.getAttributes());
                attrs.put("authorities", authoritiesList);
                peopleWithRoles.add((IPersonAttributes)new CaseInsensitiveAttributeNamedPersonImpl(this.getConfiguredUserNameAttribute(), attrs));
            }
        } else {
            peopleWithRoles.addAll(attribs);
        }
        return peopleWithRoles;
    }

    public DefaultLdapAuthoritiesPopulator getLdapAuthoritiesPopulator() {
        return this.ldapAuthoritiesPopulator;
    }

    public void setLdapAuthoritiesPopulator(DefaultLdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
    }
}

