/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStringGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLStringGenerator.class);
    private String jndiName;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserVerficationSQLString() {
        String result = "select a2.password from users a1 join local_users a2 on (a1.id=a2.id) where a1.username=? and a1.active=1";
        Connection connection = null;
        InitialContext initContext = null;
        try {
            initContext = new InitialContext();
            DataSource ds = (DataSource)initContext.lookup(this.jndiName);
            connection = ds.getConnection();
            String driverName = connection.getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("postgresql")) {
                result = "select a2.password from users a1 join local_users a2 on (a1.id=a2.id) where a1.username=? and a1.active='true'";
            }
        }
        catch (AuthenticationException ex) {
            LOGGER.error("Error authenticating user: user credentials is invalid or naming/directory service failed. ", (Throwable)ex);
        }
        catch (NamingException ex) {
            LOGGER.error("NamingException in initializing context. ", (Throwable)ex);
        }
        catch (SQLException ex) {
            LOGGER.error("SQLException in getting data source connetion or driver name. ", (Throwable)ex);
        }
        finally {
            if (initContext != null) {
                try {
                    initContext.close();
                }
                catch (NamingException ex) {
                    LOGGER.error("NamingException in closing context. ", (Throwable)ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("SQLException in closing connection. ", (Throwable)ex);
                }
            }
        }
        return result;
    }
}

