/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProperties.class);
    private static final String CONFIG_DIR_SYS_PROP = "eureka.config.dir";
    private static final String PROPERTIES_FILENAME = "application.properties";
    private static final String FALLBACK_CONFIG_FILE = "/application.properties";
    private final Properties properties = new Properties();
    private final File casDotProperties;
    private String configDir;

    public AbstractProperties() {
        this.loadFallbackConfig();
        this.loadDefaultConfig();
        this.casDotProperties = new File(this.configDir, "cas.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultConfig() {
        this.configDir = System.getProperty("eureka.config.dir");
        if (this.configDir == null) {
            this.configDir = AbstractProperties.getDefaultConfigDir();
        }
        if (this.configDir == null) {
            throw new AssertionError((Object)"eureka.config.dir not specified in /application.properties");
        }
        File configFile = new File(this.configDir, "application.properties");
        if (configFile.exists()) {
            LOGGER.info("Trying to load default configuration from {}", (Object)configFile.getAbsolutePath());
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(configFile);
                this.properties.load(inputStream);
                ((InputStream)inputStream).close();
                inputStream = null;
            }
            catch (IOException ex) {
                LOGGER.error("Error reading application.properties file {}: {}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath(), (Object)ex.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            LOGGER.warn("No configuration directory found at {0}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath());
        }
    }

    private static String getDefaultConfigDir() {
        return "/etc/ec-cas-server";
    }

    private void loadFallbackConfig() {
        InputStream inputStream = this.getClass().getResourceAsStream("/application.properties");
        try {
            this.properties.load(inputStream);
            inputStream.close();
            inputStream = null;
        }
        catch (IOException ioe) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)("Fallback configuration is unavailable: " + ioe.getMessage()));
        }
        this.properties.remove("eureka.config.dir");
    }

    public String getCasDotPropertiesPathname() {
        return this.casDotProperties.exists() ? "file:" + this.casDotProperties.getPath() : "classpath:/cas.properties";
    }

    public final String getConfigDir() {
        return this.configDir;
    }

    public String getApplicationUrl() {
        String result = this.getValue("eureka.webapp.url");
        if (result.endsWith("/")) {
            return result;
        }
        return result + "/";
    }

    protected String getValue(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    protected String getValue(String propertyName, String defaultValue) {
        String value = this.getValue(propertyName);
        if (value == null) {
            if (defaultValue == null) {
                LOGGER.warn("Property '{}' is not specified in " + this.getClass().getName() + ", and no default is specified.", (Object)propertyName);
            }
            value = defaultValue;
        }
        return value;
    }

    protected List<String> getStringListValue(String inPropertyName) {
        ArrayList<String> result;
        String value = this.properties.getProperty(inPropertyName);
        if (value != null) {
            String[] temp = value.split("\\s+");
            result = new ArrayList<String>(temp.length);
            for (String s : temp) {
                String trimmed = s.trim();
                if (trimmed.length() <= 0) continue;
                result.add(s.trim());
            }
        } else {
            result = null;
        }
        return result;
    }

    protected List<String> getStringListValue(String inPropertyName, List<String> defaultValue) {
        List<String> result = this.getStringListValue(inPropertyName);
        if (result == null) {
            LOGGER.warn("Property not found in configuration: {}", (Object)inPropertyName);
            result = defaultValue;
        }
        return result;
    }

    protected int getIntValue(String propertyName, int defaultValue) {
        int result;
        String property = this.properties.getProperty(propertyName);
        try {
            result = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer property in configuration: {}", (Object)propertyName);
            result = defaultValue;
        }
        return result;
    }
}

