/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTemplateGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTemplateGenerator.class);
    private String jndiName;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTemplate getJdbcTemplateFromJndiName() {
        JdbcTemplate jdbcTemplate = null;
        InitialContext initContext = null;
        try {
            initContext = new InitialContext();
            DataSource dataSource = (DataSource)initContext.lookup(this.jndiName);
            jdbcTemplate = new JdbcTemplate(dataSource);
        }
        catch (NamingException ex) {
            LOGGER.error("JdbcTemplateGenerator NamingException in initializing context. ", (Throwable)ex);
        }
        finally {
            if (initContext != null) {
                try {
                    initContext.close();
                }
                catch (NamingException ex) {
                    LOGGER.error("JdbcTemplateGenerator NamingException in closing context. ", (Throwable)ex);
                }
            }
        }
        return jdbcTemplate;
    }
}

