/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas.authentication;

import org.jasig.cas.authentication.principal.AbstractPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.support.oauth.authentication.principal.OAuthCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class OAuthCredentialsToPrincipalResolver
extends AbstractPersonDirectoryCredentialsToPrincipalResolver
implements CredentialsToPrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthCredentialsToPrincipalResolver.class);
    private static final String SQL = "select active from users where username=?";
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected String extractPrincipalId(Credentials credentials) {
        OAuthCredentials oauthCredentials = (OAuthCredentials)credentials;
        String principalId = oauthCredentials.getUserProfile().getTypedId();
        if (principalId != null) {
            boolean active;
            try {
                active = (Boolean)this.jdbcTemplate.queryForObject(SQL, Boolean.class, new Object[]{principalId});
                LOGGER.info("result is {}", (Object)active);
            }
            catch (EmptyResultDataAccessException ex) {
                LOGGER.info("no rows returned", (Throwable)ex);
                active = false;
            }
            if (!active) {
                return null;
            }
        }
        this.log.debug("principalId : {}", (Object)principalId);
        return principalId;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && OAuthCredentials.class.isAssignableFrom(credentials.getClass());
    }
}

