/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas;

import edu.emory.cci.aiw.cvrg.eureka.cas.ApplicationProperties;
import edu.emory.cci.aiw.cvrg.eureka.cas.EmailException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerEmailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreeMarkerEmailSender.class);
    private final Configuration configuration;
    private final Session session;
    private final ApplicationProperties applicationProperties;

    public FreeMarkerEmailSender(ApplicationProperties inApplicationProperties, Session inSession) {
        this.applicationProperties = inApplicationProperties;
        this.session = inSession;
        this.configuration = new Configuration();
        this.configuration.setClassForTemplateLoading(this.getClass(), "/templates/");
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public void sendPasswordResetMessage(String inEmailAdress, String inFirstName, String inLastName, String inNewPassword) throws EmailException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("plainTextPassword", inNewPassword);
        this.sendMessage1(inEmailAdress, inFirstName, inLastName, "password_reset.ftl", "Password reset on Eureka! Clinical Analytics", params);
    }

    private void sendMessage1(String inEmailAdress, String inFirstName, String inLastName, String templateName, String emailSubject, Map<String, Object> params) throws EmailException {
        params.put("firstName", inFirstName);
        params.put("lastName", inLastName);
        params.put("config", this.applicationProperties);
        this.sendMessage2(templateName, emailSubject, inEmailAdress, params);
    }

    private void sendMessage2(String templateName, String emailSubject, String emailAddress, Map<String, Object> params) throws EmailException {
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = this.configuration.getTemplate(templateName);
            template.process(params, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new EmailException(e);
        }
        String content = ((Object)stringWriter).toString();
        MimeMessage message = new MimeMessage(this.session);
        try {
            InternetAddress fromEmailAddress = null;
            String fromEmailAddressStr = this.applicationProperties.getFromEmailAddress();
            if (fromEmailAddressStr != null) {
                fromEmailAddress = new InternetAddress(fromEmailAddressStr);
            }
            if (fromEmailAddress == null) {
                fromEmailAddress = InternetAddress.getLocalAddress((Session)this.session);
            }
            if (fromEmailAddress == null) {
                try {
                    fromEmailAddress = new InternetAddress("no-reply@" + InetAddress.getLocalHost().getCanonicalHostName());
                }
                catch (UnknownHostException ex) {
                    fromEmailAddress = new InternetAddress("no-reply@localhost");
                }
            }
            message.setFrom((Address)fromEmailAddress);
            message.setSubject(emailSubject);
            message.setContent((Object)content, "text/plain");
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailAddress));
            message.setSender((Address)fromEmailAddress);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            LOGGER.error("Error sending the following email message:");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                message.writeTo((OutputStream)out);
                out.close();
            }
            catch (IOException | MessagingException ex) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LOGGER.error(out.toString());
            throw new EmailException((Throwable)e);
        }
    }
}

