/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.cas.authentication;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.jasig.cas.adaptors.ldap.BindLdapAuthenticationHandler;
import org.jasig.cas.adaptors.ldap.FastBindLdapAuthenticationHandler;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.oauth.authentication.handler.support.OAuthAuthenticationHandler;

public class AuthenticationMethodMetaDataPopulator
implements AuthenticationMetaDataPopulator {
    private static final String AUTHENTICATION_METHOD = "authenticationMethod";

    public Authentication populateAttributes(Authentication authentication, Credentials credentials) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.putAll(authentication.getPrincipal().getAttributes());
        Map authenticationAttributes = authentication.getAttributes();
        Object authenticationMethod = authenticationAttributes.get(AUTHENTICATION_METHOD);
        if (OAuthAuthenticationHandler.class.getName().equals(authenticationMethod)) {
            attrs.put(AUTHENTICATION_METHOD, "OAUTH");
        } else if (QueryDatabaseAuthenticationHandler.class.getName().equals(authenticationMethod)) {
            attrs.put(AUTHENTICATION_METHOD, "LOCAL");
        } else if (FastBindLdapAuthenticationHandler.class.getName().equals(authenticationMethod) || BindLdapAuthenticationHandler.class.getName().equals(authenticationMethod)) {
            attrs.put(AUTHENTICATION_METHOD, "LDAP");
        }
        if (authenticationAttributes.containsKey("providerType")) {
            attrs.put("providerType", (String)authenticationAttributes.get("providerType"));
        }
        SimplePrincipal simplePrincipal = new SimplePrincipal(authentication.getPrincipal().getId(), attrs);
        MutableAuthentication mutableAuthentication = new MutableAuthentication((Principal)simplePrincipal, authentication.getAuthenticatedDate());
        return mutableAuthentication;
    }
}

