/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.emorysendtoehcdwh.resource;

import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eurekaclinical.patientset.client.PatientSetJsonReader;
import org.eurekaclinical.patientset.client.PatientSetJsonWriter;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Transactional
@Path(value="/protected/patientsets")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PatientSetResource {
    @POST
    public Response create(InputStream is) {
        try (PatientSetJsonReader reader = new PatientSetJsonReader(is);){
            while (reader.hasMorePatients()) {
                System.out.println("patient id " + reader.nextPatientId());
            }
            System.out.println("name: " + reader.getName());
            System.out.println("username: " + reader.getUsername());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new HttpStatusException(Response.Status.BAD_REQUEST, (Throwable)ex);
        }
        return Response.created((URI)URI.create("/1")).build();
    }

    @GET
    @Path(value="/{id}")
    public Response getPatientSet(@PathParam(value="id") Long id) {
        throw new HttpStatusException(Response.Status.NOT_FOUND);
    }

    private static /* synthetic */ void lambda$getPatientSet$0(OutputStream os) throws IOException, WebApplicationException {
        try (PatientSetJsonWriter writer = new PatientSetJsonWriter(os, "query", "username");){
            writer.writePatient("patientId");
        }
        os.flush();
    }
}

