/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.eureka.client.comm;

import org.eurekaclinical.eureka.client.comm.User;
import org.eurekaclinical.eureka.client.comm.UserVisitor;
import org.eurekaclinical.eureka.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.eureka.client.comm.authentication.LoginType;

public final class OAuthUser
extends User {
    private String providerUsername;
    private Long oauthProvider;

    public OAuthUser() {
        this.setLoginType(LoginType.PROVIDER);
    }

    public String getProviderUsername() {
        return this.providerUsername;
    }

    public void setProviderUsername(String providerUsername) {
        this.providerUsername = providerUsername;
    }

    public Long getOAuthProvider() {
        return this.oauthProvider;
    }

    public void setOAuthProvider(Long oauthProvider) {
        this.oauthProvider = oauthProvider;
    }

    @Override
    public String[] validate() {
        String[] results = super.validate();
        if (this.oauthProvider == null) {
            String[] newResults = new String[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = "OAuth provider unspecified";
            results = newResults;
        }
        return results;
    }

    @Override
    public void accept(UserVisitor userVisitor) {
        userVisitor.visit(this);
    }

    @Override
    public AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.OAUTH;
    }
}

