/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.eureka.client.comm;

import java.util.Date;
import org.eurekaclinical.eureka.client.comm.PasswordValidator;
import org.eurekaclinical.eureka.client.comm.User;
import org.eurekaclinical.eureka.client.comm.UserVisitor;
import org.eurekaclinical.eureka.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.eureka.client.comm.authentication.LoginType;

public final class LocalUser
extends User {
    private boolean verified;
    private String verificationCode;
    private String password;
    private Date passwordExpiration;

    public LocalUser() {
        this.setLoginType(LoginType.INTERNAL);
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean inVerified) {
        this.verified = inVerified;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String inVerificationCode) {
        this.verificationCode = inVerificationCode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public Date getPasswordExpiration() {
        return this.passwordExpiration;
    }

    public void setPasswordExpiration(Date inPasswordExpiration) {
        this.passwordExpiration = inPasswordExpiration;
    }

    @Override
    public String[] validate() {
        String[] results = super.validate();
        PasswordValidator passwordValidator = new PasswordValidator();
        if (!passwordValidator.validate(this.password)) {
            String[] newResults = new String[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = "Password must be at least 8 characters long.";
            results = newResults;
        }
        return results;
    }

    @Override
    public void accept(UserVisitor userVisitor) {
        userVisitor.visit(this);
    }

    @Override
    public AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.LOCAL;
    }
}

