/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.eureka.client;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.eurekaclinical.eureka.client.comm.CohortDestination;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.DestinationType;
import org.eurekaclinical.eureka.client.comm.I2B2Destination;
import org.eurekaclinical.eureka.client.comm.Job;
import org.eurekaclinical.eureka.client.comm.JobSpec;
import org.eurekaclinical.eureka.client.comm.PasswordChangeRequest;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.SourceConfig;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.eureka.client.comm.Statistics;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaClient
extends EurekaClinicalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaClient.class);
    private static final GenericType<List<SystemPhenotype>> SystemPhenotypeList = new GenericType<List<SystemPhenotype>>(){};
    private static final GenericType<List<Phenotype>> PhenotypeList = new GenericType<List<Phenotype>>(){};
    private static final GenericType<List<Role>> RoleList = new GenericType<List<Role>>(){};
    private static final GenericType<List<Job>> JobList = new GenericType<List<Job>>(){};
    private static final GenericType<List<User>> UserList = new GenericType<List<User>>(){};
    private static final GenericType<List<SourceConfig>> SourceConfigList = new GenericType<List<SourceConfig>>(){};
    private static final GenericType<List<SourceConfigParams>> SourceConfigParamsList = new GenericType<List<SourceConfigParams>>(){};
    private static final GenericType<List<Destination>> DestinationList = new GenericType<List<Destination>>(){};
    private static final GenericType<List<CohortDestination>> CohortDestinationListType = new GenericType<List<CohortDestination>>(){};
    private static final GenericType<List<I2B2Destination>> I2B2DestinationListType = new GenericType<List<I2B2Destination>>(){};
    private static final GenericType<List<String>> SystemPhenotypeSearchResultsList = new GenericType<List<String>>(){};
    private final String eurekaUrl;

    public EurekaClient(String inEurekaUrl) {
        super(null);
        this.eurekaUrl = inEurekaUrl;
    }

    protected String getResourceUrl() {
        return this.eurekaUrl;
    }

    public List<User> getUsers() throws ClientException {
        String path = "/proxy-resource/users";
        return (List)this.doGet("/proxy-resource/users", UserList);
    }

    public User getMe() throws ClientException {
        String path = "/proxy-resource/users/me";
        return (User)this.doGet(path, User.class);
    }

    public User getUserById(Long inUserId) throws ClientException {
        String path = "/proxy-resource/users/" + inUserId;
        return (User)this.doGet(path, User.class);
    }

    public void changePassword(String inOldPass, String inNewPass) throws ClientException {
        String path = "/proxy-resource/users/passwordchange";
        PasswordChangeRequest passwordChangeRequest = new PasswordChangeRequest();
        passwordChangeRequest.setOldPassword(inOldPass);
        passwordChangeRequest.setNewPassword(inNewPass);
        this.doPost("/proxy-resource/users/passwordchange", passwordChangeRequest);
    }

    public void updateUser(User inUser, Long userId) throws ClientException {
        String path = "/proxy-resource/users/" + userId;
        this.doPut(path, inUser);
    }

    public List<Role> getRoles() throws ClientException {
        String path = "/proxy-resource/roles";
        return (List)this.doGet("/proxy-resource/roles", RoleList);
    }

    public Role getRole(Long inRoleId) throws ClientException {
        String path = "/proxy-resource/roles/" + inRoleId;
        return (Role)this.doGet(path, Role.class);
    }

    public Role getRoleByName(String name) throws ClientException {
        return (Role)this.doGet("/proxy-resource/roles/byname/" + name, Role.class);
    }

    public Long submitJob(JobSpec inUpload) throws ClientException {
        String path = "/proxy-resource/jobs";
        URI jobUri = this.doPostCreate("/proxy-resource/jobs", inUpload);
        return this.extractId(jobUri);
    }

    public void upload(String fileName, String sourceId, String fileTypeId, InputStream inputStream) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/file/upload/").segment(new String[]{sourceId}).segment(new String[]{fileTypeId}).build(new Object[0]).toString();
        this.doPostMultipart(path, fileName, inputStream);
    }

    public Job getJob(Long jobId) throws ClientException {
        String path = "/proxy-resource/jobs/" + jobId;
        return (Job)this.doGet(path, Job.class);
    }

    public Statistics getJobStats(Long jobId, String propId) throws ClientException {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/proxy-resource/jobs/{arg1}/stats/");
        if (propId != null) {
            uriBuilder = uriBuilder.segment(new String[]{propId});
        }
        return (Statistics)this.doGet(uriBuilder.build(new Object[]{jobId}).toString(), Statistics.class);
    }

    public List<Job> getJobs() throws ClientException {
        String path = "/proxy-resource/jobs";
        return (List)this.doGet("/proxy-resource/jobs", JobList);
    }

    public List<Job> getJobsDesc() throws ClientException {
        String path = "/proxy-resource/jobs";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"order", (Object)"desc");
        return (List)this.doGet("/proxy-resource/jobs", JobList, (MultivaluedMap)queryParams);
    }

    public List<Job> getLatestJob() throws ClientException {
        String path = "/proxy-resource/jobs/latest";
        return (List)this.doGet("/proxy-resource/jobs/latest", JobList);
    }

    public List<Phenotype> getPhenotypes(String[] inKeys, boolean summarized) throws ClientException {
        ArrayList<Phenotype> result = new ArrayList<Phenotype>();
        if (inKeys != null) {
            ArrayList<String> userPhenotypes = new ArrayList<String>();
            ArrayList<String> systemPhenotypes = new ArrayList<String>();
            for (String key : inKeys) {
                if (key.startsWith("USER:")) {
                    userPhenotypes.add(key);
                    continue;
                }
                systemPhenotypes.add(key);
            }
            if (!userPhenotypes.isEmpty()) {
                for (String userPhenotype : userPhenotypes) {
                    result.add(this.getUserPhenotype(userPhenotype, summarized));
                }
            }
            if (!systemPhenotypes.isEmpty()) {
                result.addAll(this.getSystemPhenotypes(systemPhenotypes, summarized));
            }
        }
        return result;
    }

    public URI proxyPost(String path, String json) throws ClientException {
        return this.doPostCreate(path, json);
    }

    public void proxyDelete(String path) throws ClientException {
        this.doDelete(path);
    }

    public void proxyPut(String path, String json) throws ClientException {
        this.doPut(path, json);
    }

    public String proxyGet(String path, MultivaluedMap queryParams) throws ClientException {
        if (queryParams == null) {
            return this.doGet(path);
        }
        return this.doGet(path, queryParams);
    }

    public List<Phenotype> getUserPhenotypes(boolean summarized) throws ClientException {
        String path = "/proxy-resource/phenotypes";
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return (List)this.doGet("/proxy-resource/phenotypes", PhenotypeList, (MultivaluedMap)queryParams);
        }
        return (List)this.doGet("/proxy-resource/phenotypes", PhenotypeList);
    }

    public Phenotype getUserPhenotype(String inKey, boolean summarized) throws ClientException {
        if (inKey == null) {
            throw new IllegalArgumentException("inKey cannot be null");
        }
        String path = UriBuilder.fromPath((String)"/proxy-resource/phenotypes/").segment(new String[]{inKey}).build(new Object[0]).toString();
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return (Phenotype)this.doGet(path, Phenotype.class, (MultivaluedMap)queryParams);
        }
        return (Phenotype)this.doGet(path, Phenotype.class);
    }

    public URI saveUserPhenotype(Phenotype inPhenotype) throws ClientException {
        String path = "/proxy-resource/phenotypes";
        URI phenotypeURI = this.doPostCreate("/proxy-resource/phenotypes", inPhenotype);
        return phenotypeURI;
    }

    public void updateUserPhenotype(Long inId, Phenotype inPhenotype) throws ClientException {
        if (inId == null) {
            throw new IllegalArgumentException("inId cannot be null");
        }
        String path = "/proxy-resource/phenotypes/" + inId;
        this.doPut(path, inPhenotype);
    }

    public void deleteUserPhenotype(Long inUserId, Long inId) throws ClientException {
        if (inUserId == null) {
            throw new IllegalArgumentException("inUserId cannot be null");
        }
        if (inId == null) {
            throw new IllegalArgumentException("inId cannot be null");
        }
        String path = "/proxy-resource/phenotypes/" + inId;
        this.doDelete(path, inUserId);
    }

    public List<SystemPhenotype> getSystemPhenotypes() throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/concepts/").build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeList);
    }

    public List<SystemPhenotype> getSystemPhenotypes(List<String> inKeys, boolean summarize) throws ClientException {
        if (inKeys == null) {
            throw new IllegalArgumentException("inKeys cannot be null");
        }
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        for (String key : inKeys) {
            formParams.add((Object)"key", (Object)key);
        }
        formParams.add((Object)"summarize", (Object)Boolean.toString(summarize));
        String path = UriBuilder.fromPath((String)"/proxy-resource/concepts/").build(new Object[0]).toString();
        return (List)this.doPost(path, SystemPhenotypeList, (MultivaluedMap)formParams);
    }

    public SystemPhenotype getSystemPhenotype(String inKey, boolean summarize) throws ClientException {
        List<SystemPhenotype> result = this.getSystemPhenotypes(Collections.singletonList(inKey), summarize);
        if (result.isEmpty()) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result.get(0);
    }

    public List<SourceConfig> getSourceConfigs() throws ClientException {
        String path = "/proxy-resource/sourceconfig";
        return (List)this.doGet(path, SourceConfigList);
    }

    public SourceConfig getSourceConfig(String sourceConfigId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/sourceconfig/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        return (SourceConfig)this.doGet(path, SourceConfig.class);
    }

    public List<SourceConfigParams> getSourceConfigParams() throws ClientException {
        String path = "/proxy-resource/sourceconfig/parameters/list";
        return (List)this.doGet(path, SourceConfigParamsList);
    }

    public Long createDestination(Destination destination) throws ClientException {
        String path = "/proxy-resource/destinations";
        URI destURI = this.doPostCreate(path, destination);
        return this.extractId(destURI);
    }

    public void updateDestination(Destination destination) throws ClientException {
        String path = "/proxy-resource/destinations";
        this.doPut(path, destination);
    }

    public List<Destination> getDestinations() throws ClientException {
        String path = "/proxy-resource/destinations";
        return (List)this.doGet(path, DestinationList);
    }

    public List<CohortDestination> getCohortDestinations() throws ClientException {
        String path = "/proxy-resource/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.COHORT.name());
        return (List)this.doGet("/proxy-resource/destinations/", CohortDestinationListType, (MultivaluedMap)queryParams);
    }

    public List<I2B2Destination> getI2B2Destinations() throws ClientException {
        String path = "/proxy-resource/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.I2B2.name());
        return (List)this.doGet("/proxy-resource/destinations/", I2B2DestinationListType, (MultivaluedMap)queryParams);
    }

    public Destination getDestination(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return (Destination)this.doGet(path, Destination.class);
    }

    public void deleteDestination(Long id, String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        this.doDelete(path);
    }

    public List<String> getSystemPhenotypeSearchResults(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/concepts/search/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeSearchResultsList);
    }

    public List<SystemPhenotype> getSystemPhenotypeSearchResultsBySearchKey(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/concepts/propsearch/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeList);
    }

    public InputStream getOutput(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/output/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return (InputStream)this.doGet(path, InputStream.class);
    }
}

