/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.eureka.client.comm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eurekaclinical.eureka.client.comm.JobEvent;
import org.eurekaclinical.eureka.client.comm.JobListRow;
import org.eurekaclinical.eureka.client.comm.JobMode;
import org.eurekaclinical.eureka.client.comm.JobStatus;
import org.eurekaclinical.eureka.client.comm.Link;

public class Job {
    private Long id;
    private Date startTimestamp;
    private String sourceConfigId;
    private String destinationId;
    private String username;
    private JobStatus status;
    private List<JobEvent> jobEvents;
    private List<Link> links;
    private boolean getStatisticsSupported;
    private Date finishTimeStamp;
    private JobMode jobMode;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date timestamp) {
        this.startTimestamp = timestamp;
    }

    public String getSourceConfigId() {
        return this.sourceConfigId;
    }

    public void setSourceConfigId(String sourceConfigId) {
        this.sourceConfigId = sourceConfigId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public List<JobEvent> getJobEvents() {
        return this.jobEvents;
    }

    public void setJobEvents(List<JobEvent> jobEvents) {
        this.jobEvents = jobEvents;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean isGetStatisticsSupported() {
        return this.getStatisticsSupported;
    }

    public void setGetStatisticsSupported(boolean getStatisticsSupported) {
        this.getStatisticsSupported = getStatisticsSupported;
    }

    public Date getFinishTimestamp() {
        return this.finishTimeStamp;
    }

    public void setFinishTimestamp(Date timestamp) {
        this.finishTimeStamp = timestamp;
    }

    public void setJobMode(JobMode jobMode) {
        this.jobMode = jobMode;
    }

    public JobMode getJobMode() {
        return this.jobMode;
    }

    public List<String> messages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (JobEvent event : this.jobEvents) {
            String message = event.getMessage();
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    public JobListRow toJobListRow() {
        JobListRow jobStatus = new JobListRow();
        jobStatus.setStatus(this.getStatus());
        jobStatus.setMessages(this.messages());
        jobStatus.setStartedDate(this.getStartTimestamp());
        jobStatus.setLinks(this.getLinks());
        jobStatus.setGetStatisticsSupported(this.isGetStatisticsSupported());
        jobStatus.setJobId(this.getId());
        jobStatus.setSourceConfigId(this.getSourceConfigId());
        jobStatus.setDestinationId(this.getDestinationId());
        jobStatus.setFinishedDate(this.getFinishTimestamp());
        return jobStatus;
    }

    public String toString() {
        return "Job{id=" + this.id + ", startTimestamp=" + this.startTimestamp + ", sourceConfigId=" + this.sourceConfigId + ", destinationId=" + this.destinationId + ", username=" + this.username + ", status=" + (Object)((Object)this.status) + ", jobEvents=" + this.jobEvents + ", links=" + this.links + ", getStatisticsSupported=" + this.getStatisticsSupported + ", finishTimeStamp=" + this.finishTimeStamp + '}';
    }
}

