/*
 * #%L
 * Eureka Common
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.eurekaclinical.eureka.client.comm;

import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

/**
 * A user-created phenotype from the UI. Contains fields common to all
 * user-created phenotypes.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = SystemPhenotype.class, name = "SYSTEM"),
        @JsonSubTypes.Type(value = Category.class, name = "CATEGORIZATION"),
        @JsonSubTypes.Type(value = Sequence.class, name = "SEQUENCE"),
        @JsonSubTypes.Type(value = Frequency.class, name = "FREQUENCY"),
        @JsonSubTypes.Type(value = ValueThresholds.class, 
		        name = "VALUE_THRESHOLD") })
public abstract class Phenotype implements PhenotypeVisitable {
	
	public enum Type {
		CATEGORIZATION, SEQUENCE, FREQUENCY, VALUE_THRESHOLD, SYSTEM
	}

	private Long id;
	private String key;
	private Long userId;
	private String description;
	private String displayName;
	private boolean inSystem;
	private Date created;
	private Date lastModified;
	private boolean summarized;
	private Type type;
	private boolean internalNode;

	protected Phenotype(Type inType) {
		this.type = inType;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public boolean isInSystem() {
		return inSystem;
	}

	public void setInSystem(boolean inSystem) {
		this.inSystem = inSystem;
	}

	public Date getCreated() {
		return created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	public Date getLastModified() {
		return lastModified;
	}

	public void setLastModified(Date lastModified) {
		this.lastModified = lastModified;
	}

	public boolean isSummarized() {
		return summarized;
	}

	public void setSummarized(boolean summarized) {
		this.summarized = summarized;
	}

	public boolean isInternalNode() {
		return internalNode;
	}

	public void setInternalNode(boolean internalNode) {
		this.internalNode = internalNode;
	}

	@JsonIgnore
	public Type getType() {
		return type;
	}

    @Override
    public String toString() {
        return "Phenotype{" + "id=" + id + ", key=" + key + ", userId=" + userId + ", description=" + description + ", displayName=" + displayName + ", inSystem=" + inSystem + ", created=" + created + ", lastModified=" + lastModified + ", summarized=" + summarized + ", type=" + type + ", internalNode=" + internalNode + '}';
    }
        
}
