/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import java.util.Date;
import java.util.HashMap;

public class JobFilter {
    private final Long jobId;
    private final Long userId;
    private final String state;
    private final Date from;
    private final Date to;

    public JobFilter(Long inJobId, Long inUserId, String inState, Date inFrom, Date inTo) {
        this.jobId = inJobId;
        this.userId = inUserId;
        this.state = inState;
        this.from = null == inFrom ? null : new Date(inFrom.getTime());
        this.to = null == inTo ? null : new Date(inTo.getTime());
    }

    public JobFilter(String queryString) {
        String[] parts;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String part : parts = queryString.split("|")) {
            String[] data = part.split("=");
            if (data.length <= 1 || data[0] == null || data[1] == null) continue;
            params.put(data[0], data[1]);
        }
        this.jobId = params.get("jobId") == null ? null : Long.valueOf((String)params.get("jobId"));
        this.userId = params.get("userId") == null ? null : Long.valueOf((String)params.get("userId"));
        this.state = (String)params.get("state");
        this.from = params.get("from") == null ? null : new Date(Long.valueOf((String)params.get("from")));
        this.to = params.get("to") == null ? null : new Date(Long.valueOf((String)params.get("to")));
    }

    public final Long getJobId() {
        return this.jobId;
    }

    public final Long getUserId() {
        return this.userId;
    }

    public final String getState() {
        return this.state;
    }

    public final Date getFrom() {
        return this.from == null ? null : new Date(this.from.getTime());
    }

    public final Date getTo() {
        return this.to == null ? null : new Date(this.to.getTime());
    }

    public final String toQueryParam() {
        StringBuilder builder = new StringBuilder();
        if (this.jobId != null) {
            builder.append("jobId=").append(this.jobId);
        }
        if (this.userId != null) {
            builder.append("|userId=").append(this.userId);
        }
        if (this.state != null) {
            builder.append("|state=").append(this.state);
        }
        if (this.from != null) {
            builder.append("|from=").append(this.from.getTime());
        }
        if (this.to != null) {
            builder.append("|to=").append(this.to.getTime());
        }
        return builder.toString();
    }
}

