/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm.clients;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.AbstractClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.WebResourceWrapper;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.WebResourceWrapperFactory;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.cassupport.CasWebResourceWrapperFactory;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.arp.javautil.arrays.Arrays;

public abstract class EurekaClient
extends AbstractClient {
    private WebResourceWrapperFactory webResourceWrapperFactory = new CasWebResourceWrapperFactory();

    protected EurekaClient() {
    }

    protected WebResourceWrapper getResourceWrapper() {
        return this.webResourceWrapperFactory.getInstance(this.getResource());
    }

    protected void doDelete(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "PUT").accept(new String[]{"application/json"}).type("application/json")).delete(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT, ClientResponse.Status.ACCEPTED);
    }

    protected void doPut(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "PUT").type("application/json").accept(new String[]{"application/json"})).put(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
    }

    protected void doPut(String path, Object o) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "PUT").type("application/json").accept(new String[]{"application/json"})).put(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
    }

    protected String doGet(String path) throws ClientException {
        ClientResponse response = this.doGetResponse(path);
        return (String)response.getEntity(String.class);
    }

    protected String doGet(String path, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET", queryParams).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (String)response.getEntity(String.class);
    }

    protected <T> T doGet(String path, Class<T> cls) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doGet(String path, Class<T> cls, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected ClientResponse doGetResponse(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return response;
    }

    protected <T> T doGet(String path, GenericType<T> genericType) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doGet(String path, GenericType<T> genericType, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET", queryParams).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doPost(String path, Class<T> cls, MultivaluedMap<String, String> formParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doPost(String path, GenericType<T> genericType, MultivaluedMap<String, String> formParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected void doPost(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT);
    }

    protected void doPost(String path, Object o) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT);
    }

    protected <T> T doPost(String path, Object o, Class<T> cls) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected URI doPostCreate(String path, Object o) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED);
        return response.getLocation();
    }

    protected void doPostMultipart(String path, String filename, InputStream inputStream) throws ClientException {
        FormDataMultiPart part = new FormDataMultiPart();
        part.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(filename)).build(), (Object)inputStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "POST").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)part);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED);
    }

    protected void errorIfStatusEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, true);
    }

    protected void errorIfStatusNotEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, false);
    }

    protected Long extractId(URI uri) {
        String uriStr = uri.toString();
        return Long.valueOf(uriStr.substring(uriStr.lastIndexOf("/") + 1));
    }

    private void errorIf(ClientResponse response, ClientResponse.Status[] status, boolean bool) throws ClientException {
        ClientResponse.Status clientResponseStatus = response.getClientResponseStatus();
        if (bool) {
            if (Arrays.contains((Object[])status, (Object)clientResponseStatus)) {
                String message = (String)response.getEntity(String.class);
                throw new ClientException(clientResponseStatus, message);
            }
        } else if (!Arrays.contains((Object[])status, (Object)clientResponseStatus)) {
            String message = (String)response.getEntity(String.class);
            throw new ClientException(clientResponseStatus, message);
        }
    }
}

