/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueThresholdGroupEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PropositionChildrenVisitor
implements DataElementEntityVisitor {
    private List<? extends DataElementEntity> children;

    public List<? extends DataElementEntity> getChildren() {
        return this.children;
    }

    @Override
    public void visit(SystemProposition proposition) {
        this.children = new ArrayList<DataElementEntity>();
    }

    @Override
    public void visit(CategoryEntity categorization) {
        this.children = categorization.getMembers();
    }

    @Override
    public void visit(SequenceEntity highLevelAbstraction) {
        this.children = highLevelAbstraction.getAbstractedFrom();
    }

    @Override
    public void visit(ValueThresholdGroupEntity lowLevelAbstraction) {
        ArrayList<? extends DataElementEntity> cs = new ArrayList<DataElementEntity>();
        for (ValueThresholdEntity v : lowLevelAbstraction.getValueThresholds()) {
            cs.add(v.getAbstractedFrom());
        }
        this.children = cs;
    }

    @Override
    public void visit(FrequencyEntity sliceAbstraction) {
        this.children = Collections.singletonList(sliceAbstraction.getAbstractedFrom());
    }
}

