/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ExtendedDataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Relation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@Entity
@Table(name="sequences")
public class SequenceEntity
extends DataElementEntity {
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="primaryextendeddataelement_id")
    private ExtendedDataElement primaryExtendedDataElement;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="sequence_id")
    private List<Relation> relations;

    public SequenceEntity() {
        super(CategoryEntity.CategoryType.HIGH_LEVEL_ABSTRACTION);
    }

    public ExtendedDataElement getPrimaryExtendedDataElement() {
        return this.primaryExtendedDataElement;
    }

    public void setPrimaryExtendedDataElement(ExtendedDataElement inExtendedDataElement) {
        this.primaryExtendedDataElement = inExtendedDataElement;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> inRelations) {
        this.relations = inRelations;
    }

    public List<DataElementEntity> getAbstractedFrom() {
        HashMap<Long, DataElementEntity> entities = new HashMap<Long, DataElementEntity>();
        for (Relation relation : this.relations) {
            DataElementEntity lhs = relation.getLhsExtendedDataElement().getDataElementEntity();
            DataElementEntity rhs = relation.getRhsExtendedDataElement().getDataElementEntity();
            entities.put(lhs.getId(), lhs);
            entities.put(rhs.getId(), rhs);
        }
        return new ArrayList<DataElementEntity>(entities.values());
    }

    @Override
    public void accept(DataElementEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

