/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobListRow;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Link;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEvent;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Job {
    private Long id;
    private Date timestamp;
    private String sourceConfigId;
    private String destinationId;
    private String username;
    private JobStatus status;
    private List<JobEvent> jobEvents;
    private List<Link> links;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getSourceConfigId() {
        return this.sourceConfigId;
    }

    public void setSourceConfigId(String sourceConfigId) {
        this.sourceConfigId = sourceConfigId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public List<JobEvent> getJobEvents() {
        return this.jobEvents;
    }

    public void setJobEvents(List<JobEvent> jobEvents) {
        this.jobEvents = jobEvents;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public List<String> messages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (JobEvent event : this.jobEvents) {
            String message = event.getMessage();
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    public JobListRow toJobListRow() {
        JobListRow jobStatus = new JobListRow();
        jobStatus.setStatus(this.getStatus());
        jobStatus.setMessages(this.messages());
        jobStatus.setStartedDate(this.getTimestamp());
        jobStatus.setLinks(this.getLinks());
        jobStatus.setSourceConfigId(this.getSourceConfigId());
        jobStatus.setDestinationId(this.getDestinationId());
        if (this.jobEvents != null) {
            for (JobEvent jobEvent : this.jobEvents) {
                if (jobEvent.getStatus() != JobStatus.COMPLETED && jobEvent.getStatus() != JobStatus.FAILED) continue;
                jobStatus.setFinishedDate(jobEvent.getTimeStamp());
                break;
            }
        }
        return jobStatus;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

