/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElementField;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DestinationType;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlCohortDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlDestinationVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlI2B2Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlNeo4jDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlPatientSetExtractorDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Link;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EtlCohortDestination.class, name="COHORT"), @JsonSubTypes.Type(value=EtlI2B2Destination.class, name="I2B2"), @JsonSubTypes.Type(value=EtlNeo4jDestination.class, name="NEO4J"), @JsonSubTypes.Type(value=EtlPatientSetExtractorDestination.class, name="PATIENTSETEXTRACTOR")})
public abstract class EtlDestination {
    private Long id;
    private DestinationType type;
    private String name;
    private String description;
    private DataElementField[] dataElementFields;
    private Long ownerUserId;
    private boolean read;
    private boolean write;
    private boolean execute;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    private List<Link> links;
    private boolean getStatisticsSupported;
    private boolean allowingQueryPropositionIds;
    private List<String> requiredPropositionIds;

    public EtlDestination() {
    }

    public EtlDestination(Destination dest) {
        if (dest != null) {
            this.id = dest.getId();
            this.type = dest.getType();
            this.name = dest.getName();
            DataElementField[] etlDestDataElementFields = dest.getDataElementFields();
            if (etlDestDataElementFields != null) {
                this.dataElementFields = (DataElementField[])etlDestDataElementFields.clone();
            }
            this.ownerUserId = dest.getOwnerUserId();
            this.read = dest.isRead();
            this.write = dest.isWrite();
            this.execute = dest.isExecute();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    @JsonIgnore
    public DestinationType getType() {
        return this.type;
    }

    public Long getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(Long inUserId) {
        this.ownerUserId = inUserId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataElementField[] getDataElementFields() {
        return this.dataElementFields;
    }

    public void setDataElementFields(DataElementField[] dataElementFields) {
        this.dataElementFields = dataElementFields;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public boolean isExecute() {
        return this.execute;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean isGetStatisticsSupported() {
        return this.getStatisticsSupported;
    }

    public void setGetStatisticsSupported(boolean getStatisticsSupported) {
        this.getStatisticsSupported = getStatisticsSupported;
    }

    public abstract void accept(EtlDestinationVisitor var1);

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setAllowingQueryPropositionIds(boolean allowingQueryPropositionIds) {
        this.allowingQueryPropositionIds = allowingQueryPropositionIds;
    }

    public boolean isAllowingQueryPropositionIds() {
        return this.allowingQueryPropositionIds;
    }

    public List<String> getRequiredPropositionIds() {
        return this.requiredPropositionIds;
    }

    public void setRequiredPropositionIds(List<String> requiredPropositionIds) {
        this.requiredPropositionIds = requiredPropositionIds;
    }
}

