/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DataElementEntityVisitor;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="system_data_elements")
public class SystemProposition
extends DataElementEntity {
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private SystemType systemType;

    public SystemType getSystemType() {
        return this.systemType;
    }

    public void setSystemType(SystemType systemType) {
        this.systemType = systemType;
        this.setCatType(this.inferCategoryType());
    }

    @Override
    public void accept(DataElementEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isInSystem() {
        return true;
    }

    private CategoryEntity.CategoryType inferCategoryType() {
        if (this.systemType != null) {
            switch (this.systemType) {
                case HIGH_LEVEL_ABSTRACTION: {
                    return CategoryEntity.CategoryType.HIGH_LEVEL_ABSTRACTION;
                }
                case CONSTANT: {
                    return CategoryEntity.CategoryType.CONSTANT;
                }
                case EVENT: {
                    return CategoryEntity.CategoryType.EVENT;
                }
                case PRIMITIVE_PARAMETER: {
                    return CategoryEntity.CategoryType.PRIMITIVE_PARAMETER;
                }
                case LOW_LEVEL_ABSTRACTION: {
                    return CategoryEntity.CategoryType.LOW_LEVEL_ABSTRACTION;
                }
                case SLICE_ABSTRACTION: {
                    return CategoryEntity.CategoryType.SLICE_ABSTRACTION;
                }
                case SEQUENTIAL_TEMPORAL_PATTERN_ABSTRACTION: {
                    return CategoryEntity.CategoryType.SEQUENTIAL_TEMPORAL_PATTERN_ABSTRACTION;
                }
                case CONTEXT: {
                    return CategoryEntity.CategoryType.CONTEXT;
                }
            }
            throw new AssertionError((Object)("Invalid system type: " + (Object)((Object)this.systemType)));
        }
        return null;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum SystemType {
        CONSTANT,
        EVENT,
        PRIMITIVE_PARAMETER,
        LOW_LEVEL_ABSTRACTION,
        COMPOUND_LOW_LEVEL_ABSTRACTION,
        HIGH_LEVEL_ABSTRACTION,
        SLICE_ABSTRACTION,
        SEQUENTIAL_TEMPORAL_PATTERN_ABSTRACTION,
        CONTEXT;

    }
}

