/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm.clients;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.CohortDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DestinationType;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.I2B2Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Job;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobSpec;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.PasswordChangeRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SourceConfig;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SourceConfigParams;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Statistics;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SystemElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.UserRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EurekaClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.OAuthProvider;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Role;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ThresholdsOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueComparator;
import edu.emory.cci.aiw.cvrg.eureka.common.exception.HttpStatusException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesClient
extends EurekaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesClient.class);
    private static final GenericType<List<TimeUnit>> TimeUnitList = new GenericType<List<TimeUnit>>(){};
    private static final GenericType<List<FrequencyType>> FrequencyTypeList = new GenericType<List<FrequencyType>>(){};
    private static final GenericType<List<RelationOperator>> RelationOperatorList = new GenericType<List<RelationOperator>>(){};
    private static final GenericType<List<ThresholdsOperator>> ThresholdsOperatorList = new GenericType<List<ThresholdsOperator>>(){};
    private static final GenericType<List<ValueComparator>> ValueComparatorList = new GenericType<List<ValueComparator>>(){};
    private static final GenericType<List<SystemElement>> SystemElementList = new GenericType<List<SystemElement>>(){};
    private static final GenericType<List<DataElement>> DataElementList = new GenericType<List<DataElement>>(){};
    private static final GenericType<List<Role>> RoleList = new GenericType<List<Role>>(){};
    private static final GenericType<List<Job>> JobList = new GenericType<List<Job>>(){};
    private static final GenericType<List<User>> UserList = new GenericType<List<User>>(){};
    private static final GenericType<List<SourceConfig>> SourceConfigList = new GenericType<List<SourceConfig>>(){};
    private static final GenericType<List<SourceConfigParams>> SourceConfigParamsList = new GenericType<List<SourceConfigParams>>(){};
    private static final GenericType<List<Destination>> DestinationList = new GenericType<List<Destination>>(){};
    private static final GenericType<List<CohortDestination>> CohortDestinationListType = new GenericType<List<CohortDestination>>(){};
    private static final GenericType<List<I2B2Destination>> I2B2DestinationListType = new GenericType<List<I2B2Destination>>(){};
    private static final GenericType<List<String>> SystemElementSearchResultsList = new GenericType<List<String>>(){};
    private final String servicesUrl;

    public ServicesClient(String inServicesUrl) {
        LOGGER.debug("Using services URL {}", (Object)inServicesUrl);
        this.servicesUrl = inServicesUrl;
    }

    @Override
    protected String getResourceUrl() {
        return this.servicesUrl;
    }

    public List<User> getUsers() throws ClientException {
        String path = "/api/protected/users";
        return this.doGet("/api/protected/users", UserList);
    }

    public User getMe() throws ClientException {
        String path = "/api/protected/users/me";
        return this.doGet(path, User.class);
    }

    public User getUserById(Long inUserId) throws ClientException {
        String path = "/api/protected/users/" + inUserId;
        return this.doGet(path, User.class);
    }

    public void addUser(UserRequest inRequest) throws ClientException {
        String path = "/api/userrequests";
        this.doPostCreate("/api/userrequests", inRequest);
    }

    public void resetPassword(String username) throws ClientException {
        String path = "/api/passwordreset/" + username;
        this.doPost(path);
    }

    public void verifyUser(String inCode) throws ClientException {
        String path = "/api/userrequests/verify/" + inCode;
        this.doPut(path);
    }

    public void changePassword(String inOldPass, String inNewPass) throws ClientException {
        String path = "/api/protected/users/passwordchange";
        PasswordChangeRequest passwordChangeRequest = new PasswordChangeRequest();
        passwordChangeRequest.setOldPassword(inOldPass);
        passwordChangeRequest.setNewPassword(inNewPass);
        this.doPost("/api/protected/users/passwordchange", passwordChangeRequest);
    }

    public void updateUser(User inUser, Long userId) throws ClientException {
        String path = "/api/protected/users/" + userId;
        this.doPut(path, inUser);
    }

    public List<Role> getRoles() throws ClientException {
        String path = "/api/protected/roles";
        return this.doGet("/api/protected/roles", RoleList);
    }

    public Role getRole(Long inRoleId) throws ClientException {
        String path = "/api/protected/roles/" + inRoleId;
        return this.doGet(path, Role.class);
    }

    public URI submitJob(JobSpec inUpload) throws ClientException {
        String path = "/api/protected/jobs";
        URI jobUrl = this.doPostCreate("/api/protected/jobs", inUpload);
        return jobUrl;
    }

    public void upload(String fileName, String sourceId, String fileTypeId, InputStream inputStream) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/file/upload/").segment(new String[]{sourceId}).segment(new String[]{fileTypeId}).build(new Object[0]).toString();
        this.doPostMultipart(path, fileName, inputStream);
    }

    public Job getJob(Long jobId) throws ClientException {
        String path = "/api/protected/jobs/" + jobId;
        return this.doGet(path, Job.class);
    }

    public Statistics getJobStats(Long jobId, String propId) throws ClientException {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/api/protected/jobs/{arg1}/stats/");
        if (propId != null) {
            uriBuilder = uriBuilder.segment(new String[]{propId});
        }
        return this.doGet(uriBuilder.build(new Object[]{jobId}).toString(), Statistics.class);
    }

    public List<Job> getJobs() throws ClientException {
        String path = "/api/protected/jobs";
        return this.doGet("/api/protected/jobs", JobList);
    }

    public List<Job> getJobsDesc() throws ClientException {
        String path = "/api/protected/jobs";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"order", (Object)"desc");
        return this.doGet("/api/protected/jobs", JobList, (MultivaluedMap<String, String>)queryParams);
    }

    public List<DataElement> getDataElements(String[] inKeys, boolean summarized) throws ClientException {
        ArrayList<DataElement> result = new ArrayList<DataElement>();
        if (inKeys != null) {
            ArrayList<String> userElements = new ArrayList<String>();
            ArrayList<String> systemElements = new ArrayList<String>();
            for (String key : inKeys) {
                if (key.startsWith("USER:")) {
                    userElements.add(key);
                    continue;
                }
                systemElements.add(key);
            }
            if (!userElements.isEmpty()) {
                for (String userElement : userElements) {
                    result.add(this.getUserElement(userElement, summarized));
                }
            }
            if (!systemElements.isEmpty()) {
                result.addAll(this.getSystemElements(systemElements, summarized));
            }
        }
        return result;
    }

    public void saveUserElement(DataElement inDataElement) throws ClientException {
        String path = "/api/protected/dataelement";
        this.doPost("/api/protected/dataelement", inDataElement);
    }

    public URI proxyPost(String path, String json) throws ClientException {
        return this.doPostCreate(path, json);
    }

    public void proxyDelete(String path) throws ClientException {
        this.doDelete(path);
    }

    public void proxyPut(String path, String json) throws ClientException {
        this.doPut(path, json);
    }

    public String proxyGet(String path, MultivaluedMap queryParams) throws ClientException {
        if (queryParams == null) {
            return this.doGet(path);
        }
        return this.doGet(path, (MultivaluedMap<String, String>)queryParams);
    }

    public void updateUserElement(DataElement inDataElement) throws ClientException {
        String path = "/api/protected/dataelement";
        this.doPut("/api/protected/dataelement", inDataElement);
    }

    public List<DataElement> getUserElements(boolean summarized) throws ClientException {
        String path = "/api/protected/dataelement";
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return this.doGet("/api/protected/dataelement", DataElementList, (MultivaluedMap<String, String>)queryParams);
        }
        return this.doGet("/api/protected/dataelement", DataElementList);
    }

    public DataElement getUserElement(String inKey, boolean summarized) throws ClientException {
        if (inKey == null) {
            throw new IllegalArgumentException("inKey cannot be null");
        }
        String path = UriBuilder.fromPath((String)"/api/protected/dataelement/").segment(new String[]{inKey}).build(new Object[0]).toString();
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return this.doGet(path, DataElement.class, (MultivaluedMap<String, String>)queryParams);
        }
        return this.doGet(path, DataElement.class);
    }

    public void deleteUserElement(Long inUserId, String inKey) throws ClientException {
        if (inUserId == null) {
            throw new IllegalArgumentException("inUserId cannot be null");
        }
        if (inKey == null) {
            throw new IllegalArgumentException("inKey cannot be null");
        }
        String path = UriBuilder.fromPath((String)"/api/protected/dataelement/").segment(new String[]{"{arg1}"}).segment(new String[]{inKey}).build(new Object[]{inUserId}).toString();
        this.doDelete(path);
    }

    public List<SystemElement> getSystemElements() throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/systemelement/").build(new Object[0]).toString();
        return this.doGet(path, SystemElementList);
    }

    public List<SystemElement> getSystemElements(List<String> inKeys, boolean summarize) throws ClientException {
        if (inKeys == null) {
            throw new IllegalArgumentException("inKeys cannot be null");
        }
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        for (String key : inKeys) {
            formParams.add((Object)"key", (Object)key);
        }
        formParams.add((Object)"summarize", (Object)Boolean.toString(summarize));
        String path = UriBuilder.fromPath((String)"/api/protected/systemelement/").build(new Object[0]).toString();
        return this.doPost(path, SystemElementList, (MultivaluedMap<String, String>)formParams);
    }

    public SystemElement getSystemElement(String inKey, boolean summarize) throws ClientException {
        List<SystemElement> result = this.getSystemElements(Collections.singletonList(inKey), summarize);
        if (result.isEmpty()) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result.get(0);
    }

    public List<TimeUnit> getTimeUnitsAsc() throws ClientException {
        String path = "/api/protected/timeunits";
        return this.doGet("/api/protected/timeunits", TimeUnitList);
    }

    public TimeUnit getTimeUnit(Long inId) throws ClientException {
        String path = "/api/protected/timeunits/" + inId;
        return this.doGet(path, TimeUnit.class);
    }

    public TimeUnit getTimeUnitByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/timeunits/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return this.doGet(path, TimeUnit.class);
    }

    public List<RelationOperator> getRelationOperatorsAsc() throws ClientException {
        String path = "/api/protected/relationops";
        return this.doGet("/api/protected/relationops", RelationOperatorList);
    }

    public RelationOperator getRelationOperator(Long inId) throws ClientException {
        String path = "/api/protected/relationops/" + inId;
        return this.doGet(path, RelationOperator.class);
    }

    public RelationOperator getRelationOperatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/relationops/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return this.doGet(path, RelationOperator.class);
    }

    public OAuthProvider getOAuthProvider(Long inId) throws ClientException {
        String path = "/api/protected/oauthproviders/" + inId;
        return this.doGet(path, OAuthProvider.class);
    }

    public OAuthProvider getOAuthProviderByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/oauthproviders/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return this.doGet(path, OAuthProvider.class);
    }

    public List<ThresholdsOperator> getThresholdsOperators() throws ClientException {
        String path = "/api/protected/thresholdsop/list";
        return this.doGet("/api/protected/thresholdsop/list", ThresholdsOperatorList);
    }

    public ThresholdsOperator getThresholdsOperator(Long inId) throws ClientException {
        String path = "/api/protected/thresholdsop/" + inId;
        return this.doGet(path, ThresholdsOperator.class);
    }

    public ThresholdsOperator getThresholdsOperatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/thresholdsop/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return this.doGet(path, ThresholdsOperator.class);
    }

    public List<ValueComparator> getValueComparatorsAsc() throws ClientException {
        String path = "/api/protected/valuecomps";
        return this.doGet("/api/protected/valuecomps", ValueComparatorList);
    }

    public ValueComparator getValueComparator(Long inId) throws ClientException {
        String path = "/api/protected/valuecomps/" + inId;
        return this.doGet(path, ValueComparator.class);
    }

    public ValueComparator getValueComparatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/valuecomps/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return this.doGet(path, ValueComparator.class);
    }

    public List<FrequencyType> getFrequencyTypesAsc() throws ClientException {
        String path = "/api/protected/frequencytypes";
        return this.doGet("/api/protected/frequencytypes", FrequencyTypeList);
    }

    public List<SourceConfig> getSourceConfigs() throws ClientException {
        String path = "/api/protected/sourceconfig";
        return this.doGet(path, SourceConfigList);
    }

    public SourceConfig getSourceConfig(String sourceConfigId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/sourceconfig/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        return this.doGet(path, SourceConfig.class);
    }

    public List<SourceConfigParams> getSourceConfigParams() throws ClientException {
        String path = "/api/protected/sourceconfig/parameters/list";
        return this.doGet(path, SourceConfigParamsList);
    }

    public URI createDestination(Destination destination) throws ClientException {
        String path = "/api/protected/destinations";
        URI destURI = this.doPostCreate(path, destination);
        return destURI;
    }

    public void updateDestination(Destination destination) throws ClientException {
        String path = "/api/protected/destinations";
        this.doPut(path, destination);
    }

    public List<Destination> getDestinations() throws ClientException {
        String path = "/api/protected/destinations";
        return this.doGet(path, DestinationList);
    }

    public List<CohortDestination> getCohortDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.COHORT.name());
        return this.doGet("/api/protected/destinations/", CohortDestinationListType, (MultivaluedMap<String, String>)queryParams);
    }

    public List<I2B2Destination> getI2B2Destinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.I2B2.name());
        return this.doGet("/api/protected/destinations/", I2B2DestinationListType, (MultivaluedMap<String, String>)queryParams);
    }

    public Destination getDestination(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return this.doGet(path, Destination.class);
    }

    public void deleteDestination(Long id, String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        this.doDelete(path);
    }

    public List<String> getSystemElementSearchResults(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/systemelement/search/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return this.doGet(path, SystemElementSearchResultsList);
    }

    public List<SystemElement> getSystemElementSearchResultsBySearchKey(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/systemelement/propsearch/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return this.doGet(path, SystemElementList);
    }

    public InputStream getOutput(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/output/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return this.doGet(path, InputStream.class);
    }
}

