/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Relation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@Entity
@Table(name="sequences")
public class SequenceEntity
extends PhenotypeEntity {
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="primaryextendedphenotype_id")
    private ExtendedPhenotype primaryExtendedPhenotype;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="sequence_id")
    private List<Relation> relations;

    public SequenceEntity() {
        super(CategoryEntity.CategoryType.HIGH_LEVEL_ABSTRACTION);
    }

    public ExtendedPhenotype getPrimaryExtendedPhenotype() {
        return this.primaryExtendedPhenotype;
    }

    public void setPrimaryExtendedPhenotype(ExtendedPhenotype inExtendedPhenotype) {
        this.primaryExtendedPhenotype = inExtendedPhenotype;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> inRelations) {
        this.relations = inRelations;
    }

    public List<PhenotypeEntity> getAbstractedFrom() {
        HashMap<Long, PhenotypeEntity> entities = new HashMap<Long, PhenotypeEntity>();
        for (Relation relation : this.relations) {
            PhenotypeEntity lhs = relation.getLhsExtendedPhenotype().getPhenotypeEntity();
            PhenotypeEntity rhs = relation.getRhsExtendedPhenotype().getPhenotypeEntity();
            entities.put(lhs.getId(), lhs);
            entities.put(rhs.getId(), rhs);
        }
        return new ArrayList<PhenotypeEntity>(entities.values());
    }

    @Override
    public void accept(PhenotypeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

