/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.filter;

import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.common.filter.RolesRequestWrapper;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RolesFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesFilter.class);
    private DataSource dataSource;
    private String sql;
    private String colName;

    public void init(FilterConfig inFilterConfig) throws ServletException {
        this.sql = inFilterConfig.getInitParameter("sql");
        LOGGER.debug("Got SQL {}", (Object)this.sql);
        this.colName = inFilterConfig.getInitParameter("rolecolumn");
        LOGGER.debug("Got column name {}", (Object)this.colName);
        String sourceName = inFilterConfig.getInitParameter("datasource");
        LOGGER.debug("Using datasource {}", (Object)sourceName);
        try {
            InitialContext context = new InitialContext();
            this.dataSource = (DataSource)context.lookup(sourceName);
        }
        catch (NamingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        Principal principal = servletRequest.getUserPrincipal();
        if (principal != null) {
            HashSet<String> roles = new HashSet<String>();
            String name = principal.getName();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                preparedStatement = connection.prepareStatement(this.sql);
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String role = resultSet.getString(this.colName);
                    if (role == null) continue;
                    LOGGER.debug("Assigning role {}", (Object)role);
                    roles.add(role);
                }
                this.close(resultSet, preparedStatement, connection);
            }
            catch (SQLException e) {
                try {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
            }
            RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roles);
            inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    private void close(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sqle) {
                LOGGER.error(sqle.getMessage(), (Throwable)sqle);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sqle) {
                LOGGER.error(sqle.getMessage(), (Throwable)sqle);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sqle) {
                LOGGER.error(sqle.getMessage(), (Throwable)sqle);
            }
        }
    }

    public void destroy() {
    }
}

