/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.filter;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesRequestWrapper.class);
    private final Principal principal;
    private final Set<String> roles;
    private final HttpServletRequest request;

    public RolesRequestWrapper(HttpServletRequest inRequest, Principal inPrincipal, Set<String> inRoles) {
        super(inRequest);
        this.request = inRequest;
        this.principal = inPrincipal;
        this.roles = inRoles;
    }

    public boolean isUserInRole(String inRole) {
        boolean result = this.roles == null ? this.request.isUserInRole(inRole) : this.roles.contains(inRole);
        return result;
    }

    public Principal getUserPrincipal() {
        Principal result = this.principal == null ? this.request.getUserPrincipal() : this.principal;
        return result;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

