/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.Node;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.NodeVisitor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.AbsoluteTimeIntervalFactory;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;
import org.protempa.proposition.visitor.PropositionVisitor;

public class Literal
extends Node {
    private String name;
    private Date start;
    private Date finish;
    private Interval interval;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getFinish() {
        return this.finish;
    }

    public void setFinish(Date finish) {
        this.finish = finish;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    boolean evaluate(Map<String, List<Proposition>> propMap) {
        List<Proposition> props = propMap.get(this.name);
        if (props != null && !props.isEmpty()) {
            if (this.interval == null && (this.start != null || this.finish != null)) {
                this.interval = new AbsoluteTimeIntervalFactory().getInstance(this.start, null, this.finish, null);
            }
            if (this.interval != null) {
                LiteralEvaluatePropositionVisitor v = new LiteralEvaluatePropositionVisitor();
                for (Proposition prop : props) {
                    prop.accept((PropositionVisitor)v);
                    if (!v.evaluate()) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void accept(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }

    private class LiteralEvaluatePropositionVisitor
    extends AbstractPropositionVisitor {
        private boolean result;

        LiteralEvaluatePropositionVisitor() {
        }

        boolean evaluate() {
            return this.result;
        }

        public void visit(Context context) {
            this.handleTemporalProposition((TemporalProposition)context);
        }

        public void visit(Constant constant) {
            this.result = true;
        }

        public void visit(PrimitiveParameter primitiveParameter) {
            this.handleTemporalProposition((TemporalProposition)primitiveParameter);
        }

        public void visit(Event event) {
            this.handleTemporalProposition((TemporalProposition)event);
        }

        public void visit(AbstractParameter abstractParameter) {
            this.handleTemporalProposition((TemporalProposition)abstractParameter);
        }

        private void handleTemporalProposition(TemporalProposition tempProp) {
            Interval tempPropIval = tempProp.getInterval();
            this.result = Relation.CONTAINS_OR_EQUALS.hasRelation(Literal.this.interval, tempPropIval);
        }
    }
}

