/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import com.sun.xml.bind.CycleRecoverable;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonBackReference;

@Entity
@Table(name="job_events")
public class JobEvent
implements CycleRecoverable {
    @Id
    @SequenceGenerator(name="JOBEVENT_SEQ_GENERATOR", sequenceName="JOBEVENT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="JOBEVENT_SEQ_GENERATOR")
    private Long id;
    @ManyToOne
    @JoinColumn(name="job_id", nullable=false)
    private JobEntity job;
    @Column(nullable=false, name="state")
    private JobStatus status;
    @Lob
    @Column(name="exceptionstacktrace")
    private String zExceptionStackTrace;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date timeStamp = new Date();
    @Lob
    private String message;

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    @JsonBackReference(value="job-event")
    public JobEntity getJob() {
        return this.job;
    }

    public void setJob(JobEntity inJob) {
        if (this.job != inJob) {
            if (this.job != null) {
                this.job.removeJobEvent(this);
            }
            this.job = inJob;
            if (this.job != null) {
                this.job.addJobEvent(this);
            }
        }
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus inStatus) {
        this.status = inStatus;
    }

    public String getExceptionStackTrace() {
        return this.zExceptionStackTrace;
    }

    public void setExceptionStackTrace(String inExceptionStackTrace) {
        this.zExceptionStackTrace = inExceptionStackTrace;
    }

    public Date getTimeStamp() {
        return new Date(this.timeStamp.getTime());
    }

    public void setTimeStamp(Date inTimeStamp) {
        this.timeStamp = inTimeStamp == null ? new Date() : new Date(inTimeStamp.getTime());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String inMessage) {
        this.message = inMessage;
    }

    public Object onCycleDetected(CycleRecoverable.Context inContext) {
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

