/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.authentication;

import edu.emory.cci.aiw.cvrg.eureka.common.authentication.AbstractUserSupport;
import edu.emory.cci.aiw.cvrg.eureka.common.dao.AuthorizedUserDao;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.AuthorizedUserEntity;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedUserSupport
extends AbstractUserSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizedUserSupport.class);
    private final AuthorizedUserDao userDao;

    public AuthorizedUserSupport(AuthorizedUserDao inUserDao) {
        this.userDao = inUserDao;
    }

    public boolean isSameUser(HttpServletRequest servletRequest, AuthorizedUserEntity user) {
        return this.isSameUser(servletRequest, user.getUsername());
    }

    public AuthorizedUserEntity getUser(HttpServletRequest servletRequest) {
        AttributePrincipal principal = this.getUserPrincipal(servletRequest);
        AuthorizedUserEntity result = this.userDao.getByAttributePrincipal(principal);
        if (result == null) {
            throw new HttpStatusException(Response.Status.FORBIDDEN, "User " + principal.getName() + " is unauthorized to use this resource");
        }
        return result;
    }
}

