/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.Job;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Link;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.AuthorizedUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEvent;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEventComparator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.LinkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonManagedReference;

@Entity
@Table(name="jobs")
public class JobEntity {
    @Id
    @SequenceGenerator(name="JOB_SEQ_GENERATOR", sequenceName="JOB_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="JOB_SEQ_GENERATOR")
    private Long id;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created = new Date();
    @Column(nullable=false)
    private String sourceConfigId;
    @ManyToOne
    @JoinColumn(name="destination_id", referencedColumnName="id", nullable=false)
    private DestinationEntity destination;
    @ManyToOne
    @JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
    private AuthorizedUserEntity user;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="job")
    private List<JobEvent> jobEvents = new ArrayList<JobEvent>();
    private String name;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date finished;
    private static JobEventComparator JOB_EVENT_COMPARATOR = new JobEventComparator();

    public Date getFinished() {
        return this.finished;
    }

    public void setFinished(Date finished) {
        this.finished = finished;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date inTimestamp) {
        this.created = inTimestamp;
    }

    public String getSourceConfigId() {
        return this.sourceConfigId;
    }

    public void setSourceConfigId(String inSourceConfigId) {
        this.sourceConfigId = inSourceConfigId;
    }

    public DestinationEntity getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEntity inDestination) {
        this.destination = inDestination;
    }

    public AuthorizedUserEntity getUser() {
        return this.user;
    }

    public void setUser(AuthorizedUserEntity inEtlUser) {
        this.user = inEtlUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonManagedReference(value="job-event")
    public List<JobEvent> getJobEvents() {
        return new ArrayList<JobEvent>(this.jobEvents);
    }

    public void setJobEvents(List<JobEvent> inJobEvents) {
        if (inJobEvents == null) {
            this.jobEvents = new ArrayList<JobEvent>();
        } else {
            this.jobEvents = new ArrayList<JobEvent>(inJobEvents);
            for (JobEvent jobEvent : this.jobEvents) {
                jobEvent.setJob(this);
            }
        }
    }

    public void addJobEvent(JobEvent jobEvent) {
        if (!this.jobEvents.contains(jobEvent)) {
            this.jobEvents.add(jobEvent);
            jobEvent.setJob(this);
        }
    }

    public void removeJobEvent(JobEvent jobEvent) {
        if (this.jobEvents.remove(jobEvent)) {
            jobEvent.setJob(null);
        }
    }

    public JobStatus getCurrentStatus() {
        JobEvent jev;
        List<JobEvent> jobEventsInReverseOrder = this.getJobEventsInReverseOrder();
        JobStatus result = jobEventsInReverseOrder.isEmpty() ? JobStatus.STARTING : ((jev = jobEventsInReverseOrder.get(0)) != null ? jev.getStatus() : JobStatus.STARTING);
        return result;
    }

    public List<JobEvent> getJobEventsInOrder() {
        ArrayList<JobEvent> ts = new ArrayList<JobEvent>(this.jobEvents);
        Collections.sort(ts, JOB_EVENT_COMPARATOR);
        return ts;
    }

    public List<JobEvent> getJobEventsInReverseOrder() {
        ArrayList<JobEvent> ts = new ArrayList<JobEvent>(this.jobEvents);
        Collections.sort(ts, Collections.reverseOrder(JOB_EVENT_COMPARATOR));
        return ts;
    }

    public Job toJob() {
        Job job = new Job();
        job.setDestinationId(this.destination.getName());
        job.setSourceConfigId(this.sourceConfigId);
        job.setStartTimestamp(this.created);
        job.setId(this.id);
        if (this.user != null) {
            job.setUsername(this.user.getUsername());
        }
        job.setStatus(this.getCurrentStatus());
        job.setJobEvents(this.getJobEventsInOrder());
        job.setFinishTimestamp(this.finished);
        List<LinkEntity> linkEntities = this.destination.getLinks();
        ArrayList<Link> links = new ArrayList<Link>(linkEntities != null ? linkEntities.size() : 0);
        if (linkEntities != null) {
            for (LinkEntity le : linkEntities) {
                links.add(le.toLink());
            }
        }
        job.setLinks(links);
        return job;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

