/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import edu.emory.cci.aiw.cvrg.eureka.common.authentication.AuthenticationMethod;
import edu.emory.cci.aiw.cvrg.eureka.common.authentication.LoginType;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.UserVisitor;

public final class OAuthUser
extends User {
    private String providerUsername;
    private Long oauthProvider;

    public OAuthUser() {
        this.setLoginType(LoginType.PROVIDER);
    }

    public String getProviderUsername() {
        return this.providerUsername;
    }

    public void setProviderUsername(String providerUsername) {
        this.providerUsername = providerUsername;
    }

    public Long getOAuthProvider() {
        return this.oauthProvider;
    }

    public void setOAuthProvider(Long oauthProvider) {
        this.oauthProvider = oauthProvider;
    }

    @Override
    public String[] validate() {
        String[] results = super.validate();
        if (this.oauthProvider == null) {
            String[] newResults = new String[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = "OAuth provider unspecified";
            results = newResults;
        }
        return results;
    }

    @Override
    public void accept(UserVisitor userVisitor) {
        userVisitor.visit(this);
    }

    @Override
    public AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.OAUTH;
    }
}

