/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.cassupport;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.AbstractWebResourceWrapper;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import javax.ws.rs.core.MultivaluedMap;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.AssertionHolder;
import org.jasig.cas.client.validation.Assertion;

public class CasWebResourceWrapper
extends AbstractWebResourceWrapper {
    CasWebResourceWrapper(WebResource inWebResource) {
        super(inWebResource);
    }

    @Override
    public WebResource rewritten(String path, String method, MultivaluedMap<String, String> queryParams) throws ClientException {
        WebResource webResource = this.getWebResource();
        if (queryParams != null) {
            webResource = webResource.queryParams(queryParams);
        }
        webResource = webResource.path(path);
        webResource = CasWebResourceWrapper.withProxyTicket(webResource);
        return webResource;
    }

    private static WebResource withProxyTicket(WebResource webResource) throws ClientException {
        Assertion assertion = AssertionHolder.getAssertion();
        if (assertion != null) {
            AttributePrincipal principal = assertion.getPrincipal();
            String proxyTicket = principal.getProxyTicketFor(webResource.getURI().toString());
            if (proxyTicket == null) {
                throw new ClientException(ClientResponse.Status.UNAUTHORIZED, "Could not get proxy ticket for service call " + webResource.getURI().toString());
            }
            return webResource.queryParam("ticket", proxyTicket);
        }
        return webResource;
    }
}

