/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.AuthorizedRoleEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.EtlGroup;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SourceConfigEntity;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.eurekaclinical.standardapis.entity.UserEntity;

@Entity
@Table(name="users")
public class AuthorizedUserEntity
implements UserEntity<AuthorizedRoleEntity> {
    @Id
    @SequenceGenerator(name="USER_SEQ_GENERATOR", sequenceName="USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    private List<JobEntity> jobs = new ArrayList<JobEntity>();
    @ManyToMany
    private List<EtlGroup> groups;
    @OneToMany(mappedBy="owner")
    private List<SourceConfigEntity> sourceConfigs;
    @OneToMany(mappedBy="owner")
    private List<DestinationEntity> destinations;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<AuthorizedRoleEntity> roles = new ArrayList<AuthorizedRoleEntity>();

    public AuthorizedUserEntity() {
        this.sourceConfigs = new ArrayList<SourceConfigEntity>();
        this.destinations = new ArrayList<DestinationEntity>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String inUsername) {
        this.username = inUsername;
    }

    public List<JobEntity> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<JobEntity> jobs) {
        this.jobs = jobs == null ? new ArrayList<JobEntity>() : jobs;
    }

    public List<EtlGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<EtlGroup> groups) {
        this.groups = groups;
    }

    public List<SourceConfigEntity> getSourceConfigs() {
        return this.sourceConfigs;
    }

    public void setSourceConfigs(List<SourceConfigEntity> sourceConfigs) {
        this.sourceConfigs = sourceConfigs == null ? new ArrayList<SourceConfigEntity>() : sourceConfigs;
    }

    public List<DestinationEntity> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(List<DestinationEntity> destinations) {
        this.destinations = destinations == null ? new ArrayList<DestinationEntity>() : destinations;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public List<AuthorizedRoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(List<AuthorizedRoleEntity> inRoles) {
        this.roles = inRoles == null ? new ArrayList<AuthorizedRoleEntity>() : inRoles;
    }
}

