/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.AuthorizedUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ConfigEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DeidPerPatientParams;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationGroupMembership;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.EncryptionAlgorithm;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.LinkEntity;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="destinations")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class DestinationEntity
implements ConfigEntity {
    @Id
    @SequenceGenerator(name="DEST_SEQ_GENERATOR", sequenceName="DEST_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DEST_SEQ_GENERATOR")
    private Long id;
    @Column(nullable=false, unique=true)
    private String name;
    @Lob
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at")
    private Date createdAt;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="effective_at")
    private Date effectiveAt;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expired_at")
    private Date expiredAt;
    @ManyToOne
    private AuthorizedUserEntity owner;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="destination")
    private List<DestinationGroupMembership> groups;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="destination")
    private List<LinkEntity> links;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="destination")
    private List<DeidPerPatientParams> offsets;
    private boolean deidentificationEnabled;
    @ManyToOne
    private EncryptionAlgorithm encryptionAlgorithm;
    private String outputName;
    private String outputType = "application/octet-stream";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public AuthorizedUserEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(AuthorizedUserEntity owner) {
        this.owner = owner;
    }

    public List<DestinationGroupMembership> getGroups() {
        return this.groups;
    }

    public void setGroups(List<DestinationGroupMembership> groups) {
        this.groups = groups;
    }

    public List<LinkEntity> getLinks() {
        return this.links;
    }

    public void setLinks(List<LinkEntity> links) {
        this.links = links;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getEffectiveAt() {
        return this.effectiveAt;
    }

    public void setEffectiveAt(Date effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    public Date getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(Date expiredAt) {
        this.expiredAt = expiredAt;
    }

    public List<DeidPerPatientParams> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<DeidPerPatientParams> offsets) {
        this.offsets = offsets;
    }

    public void setDeidentificationEnabled(boolean enabled) {
        this.deidentificationEnabled = enabled;
    }

    public boolean isDeidentificationEnabled() {
        return this.deidentificationEnabled;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType == null ? "application/octet-stream" : outputType;
    }

    public abstract boolean isGetStatisticsSupported();

    public abstract boolean isAllowingQueryPropositionIds();

    public abstract void accept(DestinationEntityVisitor var1);
}

