/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.props;

import edu.emory.cci.aiw.cvrg.eureka.common.props.SupportUri;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProperties
extends EurekaClinicalProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProperties.class);

    public AbstractProperties() {
        super("/etc/eureka");
    }

    public String getApplicationUrl() {
        String result = this.getValue("eureka.webapp.url");
        if (result.endsWith("/")) {
            return result;
        }
        return result + "/";
    }

    public String getMajorVersion() {
        return this.getValue("eureka.version.major");
    }

    public String getMinorVersion() {
        return this.getValue("eureka.version.minor");
    }

    public String getIncrementalVersion() {
        return this.getValue("eureka.version.incremental");
    }

    public String getQualifier() {
        return this.getValue("eureka.version.qualifier");
    }

    public String getBuildNumber() {
        return this.getValue("eureka.version.buildNumber");
    }

    public SupportUri getSupportUri() {
        SupportUri supportUri = null;
        try {
            String uriStr = this.getValue("eureka.support.uri");
            String uriName = this.getValue("eureka.support.uri.name");
            if (uriStr != null) {
                supportUri = new SupportUri(new URI(uriStr), uriName);
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Invalid support URI in application.properties", (Throwable)ex);
        }
        return supportUri;
    }

    public List<String> getDefaultSystemPropositions() {
        return this.getStringListValue("eureka.services.defaultprops", new ArrayList());
    }
}

