/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueThresholdGroupEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PropositionChildrenVisitor
implements PhenotypeEntityVisitor {
    private List<? extends PhenotypeEntity> children;

    public List<? extends PhenotypeEntity> getChildren() {
        return this.children;
    }

    @Override
    public void visit(SystemProposition proposition) {
        this.children = new ArrayList<PhenotypeEntity>();
    }

    @Override
    public void visit(CategoryEntity categorization) {
        this.children = categorization.getMembers();
    }

    @Override
    public void visit(SequenceEntity highLevelAbstraction) {
        this.children = highLevelAbstraction.getAbstractedFrom();
    }

    @Override
    public void visit(ValueThresholdGroupEntity lowLevelAbstraction) {
        ArrayList<? extends PhenotypeEntity> cs = new ArrayList<PhenotypeEntity>();
        for (ValueThresholdEntity v : lowLevelAbstraction.getValueThresholds()) {
            cs.add(v.getAbstractedFrom());
        }
        this.children = cs;
    }

    @Override
    public void visit(FrequencyEntity sliceAbstraction) {
        this.children = Collections.singletonList(sliceAbstraction.getAbstractedFrom());
    }
}

