/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.config;

import edu.emory.cci.aiw.cvrg.eureka.common.config.AbstractJerseyServletModuleWithPersist;
import edu.emory.cci.aiw.cvrg.eureka.common.props.AbstractProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletModuleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJerseyServletModuleWithPersist.class);
    private static final String CAS_CALLBACK_PATH = "/proxyCallback";
    private static final String ROLES_SQL = "select a.name as role from roles a, user_role b, users c where a.id=b.role_id and b.user_id=c.id and c.username=?";
    private static final String ROLE_COLUMN = "role";
    private static final String SERVICES_JNDI_NAME = "java:comp/env/jdbc/EurekaService";
    private final AbstractProperties properties;
    private final String contextPath;

    ServletModuleSupport(String contextPath, AbstractProperties inProperties) {
        this.properties = inProperties;
        this.contextPath = contextPath;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    Map<String, String> getRolesFilterInitParams() {
        HashMap<String, String> rolesFilterInitParams = new HashMap<String, String>();
        rolesFilterInitParams.put("datasource", SERVICES_JNDI_NAME);
        rolesFilterInitParams.put("sql", ROLES_SQL);
        rolesFilterInitParams.put("rolecolumn", ROLE_COLUMN);
        if (LOGGER.isDebugEnabled()) {
            this.printParams(rolesFilterInitParams);
        }
        return rolesFilterInitParams;
    }

    Map<String, String> getCasProxyFilterInitParamsForWebApp() {
        Map<String, String> params = this.getCasProxyFilterInitParams();
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    Map<String, String> getCasProxyFilterInitParamsForWebService() {
        Map<String, String> params = this.getCasProxyFilterInitParams();
        params.put("redirectAfterValidation", "false");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    private Map<String, String> getCasProxyFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acceptAnyProxy", "true");
        params.put("proxyCallbackUrl", this.getProxyCallbackUrl());
        params.put("proxyReceptorUrl", this.getProxyReceptorUrl());
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        return params;
    }

    Map<String, String> getCasAuthenticationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerLoginUrl", this.getCasLoginUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("renew", "false");
        params.put("gateway", "false");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    Map<String, String> getServletRequestWrapperFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roleAttribute", "authorities");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    private String getProxyCallbackUrl() {
        return this.properties.getProxyCallbackServer() + this.contextPath + CAS_CALLBACK_PATH;
    }

    private String getProxyReceptorUrl() {
        return CAS_CALLBACK_PATH;
    }

    protected String getCasLoginUrl() {
        return this.properties.getCasLoginUrl();
    }
}

