/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.LdapUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LocalUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.OAuthUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.LdapUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.LocalUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.OAuthUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Role;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntityVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserEntityToUserVisitor
implements UserEntityVisitor {
    private final List<User> results = new ArrayList<User>();

    public void visit(Collection<? extends UserEntity> userEntities) {
        for (UserEntity userEntity : userEntities) {
            userEntity.accept(this);
        }
    }

    @Override
    public void visit(LocalUserEntity localUserEntity) {
        LocalUser localUser = new LocalUser();
        this.toUser(localUser, localUserEntity);
        localUser.setPassword(localUserEntity.getPassword());
        localUser.setPasswordExpiration(localUserEntity.getPasswordExpiration());
        localUser.setVerificationCode(localUserEntity.getVerificationCode());
        localUser.setVerified(localUserEntity.isVerified());
        this.results.add(localUser);
    }

    @Override
    public void visit(LdapUserEntity ldapUserEntity) {
        LdapUser ldapUser = new LdapUser();
        this.toUser(ldapUser, ldapUserEntity);
        this.results.add(ldapUser);
    }

    @Override
    public void visit(OAuthUserEntity oauthUserEntity) {
        OAuthUser oauthUser = new OAuthUser();
        this.toUser(oauthUser, oauthUserEntity);
        oauthUser.setProviderUsername(oauthUserEntity.getProviderUsername());
        oauthUser.setOAuthProvider(oauthUserEntity.getOAuthProvider().getId());
        this.results.add(oauthUser);
    }

    public List<User> getUsers() {
        return new ArrayList<User>(this.results);
    }

    public User getUser() {
        return this.results.isEmpty() ? null : this.results.get(0);
    }

    private void toUser(User user, UserEntity inUserEntity) {
        if (inUserEntity != null) {
            user.setId(inUserEntity.getId());
            user.setActive(inUserEntity.isActive());
            user.setUsername(inUserEntity.getUsername());
            user.setEmail(inUserEntity.getEmail());
            user.setFirstName(inUserEntity.getFirstName());
            user.setLastName(inUserEntity.getLastName());
            user.setFullName(inUserEntity.getFullName());
            user.setLastLogin(inUserEntity.getLastLogin());
            user.setOrganization(inUserEntity.getOrganization());
            user.setRoles(this.rolesToRoleIds(inUserEntity.getRoles()));
            user.setDepartment(inUserEntity.getDepartment());
            user.setTitle(inUserEntity.getTitle());
        }
    }

    private List<Long> rolesToRoleIds(List<Role> inRoles) {
        ArrayList<Long> roleIds = new ArrayList<Long>(inRoles.size());
        for (Role role : inRoles) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }
}

