/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.props;

import edu.emory.cci.aiw.cvrg.eureka.common.props.SupportUri;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProperties.class);
    private static final String CONFIG_DIR_SYS_PROP = "eureka.config.dir";
    private static final String PROPERTIES_FILENAME = "application.properties";
    private static final String FALLBACK_CONFIG_FILE = "/application.properties";
    private final Properties properties = new Properties();
    private String configDir;

    public AbstractProperties() {
        try (InputStream inputStream = this.getClass().getResourceAsStream(FALLBACK_CONFIG_FILE);){
            this.properties.load(inputStream);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Fallback configuration is unavailable: " + ioe.getMessage()));
        }
        this.configDir = System.getProperty(CONFIG_DIR_SYS_PROP);
        if (this.configDir == null) {
            this.configDir = AbstractProperties.getDefaultConfigDir();
        }
        if (this.configDir == null) {
            throw new AssertionError((Object)"eureka.config.dir not specified in /application.properties");
        }
        this.properties.remove(CONFIG_DIR_SYS_PROP);
        File configFile = new File(this.configDir, PROPERTIES_FILENAME);
        if (configFile.exists()) {
            LOGGER.info("Trying to load default configuration from {}", (Object)configFile.getAbsolutePath());
            try (FileInputStream inputStream = new FileInputStream(configFile);){
                this.properties.load(inputStream);
            }
            catch (IOException ex) {
                LOGGER.error("Error reading application.properties file {}: {}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath(), (Object)ex.getMessage());
            }
        } else {
            LOGGER.warn("No configuration file found at {}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath());
        }
    }

    public String getConfigDir() {
        return this.configDir;
    }

    private static String getDefaultConfigDir() {
        return "/etc/eureka";
    }

    public String getApplicationUrl() {
        String result = this.getValue("eureka.webapp.url");
        if (result.endsWith("/")) {
            return result;
        }
        return result + "/";
    }

    public abstract String getProxyCallbackServer();

    public String getCasUrl() {
        return this.getValue("cas.url");
    }

    public String getCasLoginUrl() {
        UriBuilder builder = UriBuilder.fromUri((String)this.getCasUrl());
        builder.path(this.getValue("cas.url.login"));
        return builder.build(new Object[0]).toString();
    }

    public String getCasLogoutUrl() {
        UriBuilder builder = UriBuilder.fromUri((String)this.getCasUrl());
        builder.path(this.getValue("cas.url.logout"));
        return builder.build(new Object[0]).toString();
    }

    public String getMajorVersion() {
        return this.getValue("eureka.version.major");
    }

    public String getMinorVersion() {
        return this.getValue("eureka.version.minor");
    }

    public String getIncrementalVersion() {
        return this.getValue("eureka.version.incremental");
    }

    public String getQualifier() {
        return this.getValue("eureka.version.qualifier");
    }

    public String getBuildNumber() {
        return this.getValue("eureka.version.buildNumber");
    }

    public String getStage() {
        return this.getValue("eureka.stage", "DEVELOPMENT");
    }

    public SupportUri getSupportUri() {
        SupportUri supportUri = null;
        try {
            String uriStr = this.getValue("eureka.support.uri");
            String uriName = this.getValue("eureka.support.uri.name");
            if (uriStr != null) {
                supportUri = new SupportUri(new URI(uriStr), uriName);
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Invalid support URI in application.properties", (Throwable)ex);
        }
        return supportUri;
    }

    protected String getValue(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    protected String getValue(String propertyName, String defaultValue) {
        String value = this.getValue(propertyName);
        if (value == null) {
            if (defaultValue == null) {
                LOGGER.warn("Property '{}' is not specified in " + this.getClass().getName() + ", and no default is specified.", (Object)propertyName);
            }
            value = defaultValue;
        }
        return value;
    }

    protected List<String> getStringListValue(String inPropertyName) {
        ArrayList<String> result = null;
        String value = this.properties.getProperty(inPropertyName);
        if (value != null) {
            String[] temp = value.split("\\s+");
            result = new ArrayList<String>(temp.length);
            for (String s : temp) {
                String trimmed = s.trim();
                if (trimmed.length() <= 0) continue;
                result.add(s.trim());
            }
        }
        return result;
    }

    protected List<String> getStringListValue(String inPropertyName, List<String> defaultValue) {
        List<String> result = this.getStringListValue(inPropertyName);
        if (result == null) {
            LOGGER.warn("Property not found in configuration: {}", (Object)inPropertyName);
            result = defaultValue;
        }
        return result;
    }

    protected int getIntValue(String propertyName, int defaultValue) {
        int result;
        String property = this.properties.getProperty(propertyName);
        try {
            result = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer property in configuration: {}", (Object)propertyName);
            result = defaultValue;
        }
        return result;
    }

    public List<String> getDefaultSystemPropositions() {
        return this.getStringListValue("eureka.services.defaultprops", new ArrayList<String>());
    }
}

