/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.authentication;

import edu.emory.cci.aiw.cvrg.eureka.common.authentication.LoginType;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LdapUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LdapUserRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LocalUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LocalUserRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.OAuthUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.OAuthUserRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.UserRequest;

public enum AuthenticationMethod {
    LOCAL(LoginType.INTERNAL),
    LDAP(LoginType.INTERNAL),
    OAUTH(LoginType.PROVIDER);

    private final LoginType loginType;

    public static AuthenticationMethod userRequestToAuthenticationMethod(UserRequest userRequest) {
        AuthenticationMethod authMethod;
        if (userRequest instanceof LocalUserRequest) {
            authMethod = LOCAL;
        } else if (userRequest instanceof LdapUserRequest) {
            authMethod = LDAP;
        } else if (userRequest instanceof OAuthUserRequest) {
            authMethod = OAUTH;
        } else {
            throw new AssertionError((Object)("Unspected userRequest type: " + userRequest.getClass().getName()));
        }
        return authMethod;
    }

    public static AuthenticationMethod userToAuthenticationMethod(User user) {
        AuthenticationMethod authMethod;
        if (user instanceof LocalUser) {
            authMethod = LOCAL;
        } else if (user instanceof LdapUser) {
            authMethod = LDAP;
        } else if (user instanceof OAuthUser) {
            authMethod = OAUTH;
        } else {
            throw new AssertionError((Object)("Unspected userRequest type: " + user.getClass().getName()));
        }
        return authMethod;
    }

    private AuthenticationMethod(LoginType loginType) {
        this.loginType = loginType;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }
}

