/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.Link;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JobListRow {
    private JobStatus state;
    private Date startedDate;
    private Date finishedDate;
    private List<String> messages;
    private List<Link> links = new ArrayList<Link>();
    private String sourceConfigId;
    private String destinationId;

    public boolean isJobSubmitted() {
        return this.state != JobStatus.COMPLETED && this.state != JobStatus.FAILED;
    }

    public Date getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate;
    }

    public Date getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(Date finishedDate) {
        this.finishedDate = finishedDate;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public JobStatus getState() {
        return this.state;
    }

    public void setStatus(JobStatus state) {
        this.state = state;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links == null ? new ArrayList<Link>() : links;
    }

    public String getStartedDateFormatted() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        return df.format(this.startedDate);
    }

    public String getFinishedDateFormatted() {
        if (this.finishedDate != null) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            return df.format(this.finishedDate);
        }
        return "";
    }

    public String getStatus() {
        switch (this.state) {
            case COMPLETED: {
                return "Completed";
            }
            case FAILED: {
                return "Failed";
            }
            case VALIDATING: 
            case VALIDATED: 
            case STARTING: 
            case STARTED: 
            case WARNING: 
            case ERROR: {
                return "In progress";
            }
        }
        throw new AssertionError((Object)("Invalid state " + (Object)((Object)this.state)));
    }

    public String getMostRecentMessage() {
        if (this.messages == null || this.messages.isEmpty()) {
            return "No errors reported";
        }
        return this.messages.get(this.messages.size() - 1);
    }

    public String getSourceConfigId() {
        return this.sourceConfigId;
    }

    public void setSourceConfigId(String sourceConfigId) {
        this.sourceConfigId = sourceConfigId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }
}

