/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.test;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import edu.emory.cci.aiw.cvrg.eureka.common.json.ObjectMapperProvider;
import edu.emory.cci.aiw.cvrg.eureka.common.test.TestDataProvider;
import javax.servlet.Filter;
import javax.servlet.ServletContextListener;

public abstract class AbstractResourceTest
extends JerseyTest {
    private final Injector injector = Guice.createInjector((Module[])this.getModules());
    private TestDataProvider dataProvider;
    private PersistService persistService;

    protected AbstractResourceTest() {
    }

    protected AppDescriptor configure() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(ObjectMapperProvider.class);
        WebAppDescriptor.Builder builder = (WebAppDescriptor.Builder)new WebAppDescriptor.Builder().contextListenerClass(this.getListener()).filterClass(this.getFilter()).clientConfig((ClientConfig)clientConfig);
        return builder.build();
    }

    public final void setUp() throws Exception {
        super.setUp();
        PersistService persistService = (PersistService)this.injector.getInstance(PersistService.class);
        persistService.start();
        this.persistService = persistService;
        TestDataProvider dataProvider = (TestDataProvider)this.injector.getInstance(this.getDataProvider());
        dataProvider.setUp();
        this.dataProvider = dataProvider;
    }

    public final void tearDown() throws Exception {
        if (this.dataProvider != null) {
            this.dataProvider.tearDown();
        }
        if (this.persistService != null) {
            this.persistService.stop();
        }
        super.tearDown();
    }

    protected final <T> T getInstance(Class<T> className) {
        return (T)this.injector.getInstance(className);
    }

    protected abstract Class<? extends ServletContextListener> getListener();

    protected abstract Class<? extends Filter> getFilter();

    protected abstract Class<? extends TestDataProvider> getDataProvider();

    protected abstract Module[] getModules();

    public WebResource resource() {
        WebResource resource = super.resource();
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter("test", "test"));
        return resource;
    }
}

