/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.LdapUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.LocalUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.OAuthUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.RoleEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntityVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eurekaclinical.eureka.client.comm.LdapUser;
import org.eurekaclinical.eureka.client.comm.LocalUser;
import org.eurekaclinical.eureka.client.comm.OAuthUser;
import org.eurekaclinical.eureka.client.comm.User;

public class UserEntityToUserVisitor
implements UserEntityVisitor {
    private final List<User> results = new ArrayList<User>();

    public void visit(Collection<? extends UserEntity> userEntities) {
        for (UserEntity userEntity : userEntities) {
            userEntity.accept(this);
        }
    }

    @Override
    public void visit(LocalUserEntity localUserEntity) {
        LocalUser localUser = new LocalUser();
        this.toUser((User)localUser, localUserEntity);
        localUser.setPassword(localUserEntity.getPassword());
        localUser.setPasswordExpiration(localUserEntity.getPasswordExpiration());
        localUser.setVerificationCode(localUserEntity.getVerificationCode());
        localUser.setVerified(localUserEntity.isVerified());
        this.results.add((User)localUser);
    }

    @Override
    public void visit(LdapUserEntity ldapUserEntity) {
        LdapUser ldapUser = new LdapUser();
        this.toUser((User)ldapUser, ldapUserEntity);
        this.results.add((User)ldapUser);
    }

    @Override
    public void visit(OAuthUserEntity oauthUserEntity) {
        OAuthUser oauthUser = new OAuthUser();
        this.toUser((User)oauthUser, oauthUserEntity);
        oauthUser.setProviderUsername(oauthUserEntity.getProviderUsername());
        oauthUser.setOAuthProvider(oauthUserEntity.getOAuthProvider().getId());
        this.results.add((User)oauthUser);
    }

    public List<User> getUsers() {
        return new ArrayList<User>(this.results);
    }

    public User getUser() {
        return this.results.isEmpty() ? null : this.results.get(0);
    }

    private void toUser(User user, UserEntity inUserEntity) {
        if (inUserEntity != null) {
            user.setId(inUserEntity.getId());
            user.setActive(inUserEntity.isActive());
            user.setUsername(inUserEntity.getUsername());
            user.setEmail(inUserEntity.getEmail());
            user.setFirstName(inUserEntity.getFirstName());
            user.setLastName(inUserEntity.getLastName());
            user.setFullName(inUserEntity.getFullName());
            user.setLastLogin(inUserEntity.getLastLogin());
            user.setOrganization(inUserEntity.getOrganization());
            user.setRoles(this.rolesToRoleIds(inUserEntity.getRoles()));
            user.setDepartment(inUserEntity.getDepartment());
            user.setTitle(inUserEntity.getTitle());
        }
    }

    private List<Long> rolesToRoleIds(List<RoleEntity> inRoles) {
        ArrayList<Long> roleIds = new ArrayList<Long>(inRoles.size());
        for (RoleEntity role : inRoles) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }
}

