/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.RoleEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntityVisitable;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.UserEntityVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="users")
@Inheritance(strategy=InheritanceType.JOINED)
public class UserEntity
implements org.eurekaclinical.standardapis.entity.UserEntity<RoleEntity>,
UserEntityVisitable {
    @Id
    @SequenceGenerator(name="USER_SEQ_GENERATOR", sequenceName="USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE}, targetEntity=RoleEntity.class)
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<RoleEntity> roles = new ArrayList<RoleEntity>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<RoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleEntity> inRoles) {
        this.roles = inRoles;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void accept(UserEntityVisitor userEntityVisitor) {
        userEntityVisitor.visit(this);
    }

    public void addRole(RoleEntity role) {
        this.roles.add(role);
    }

    public void removeRole(RoleEntity role) {
        this.roles.remove(role);
    }
}

