/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm.clients;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlCohortDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlI2B2Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlPatientSetExtractorDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlPatientSetSenderDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.EtlTabularFileDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.ValidationRequest;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EurekaClient;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.DestinationType;
import org.eurekaclinical.eureka.client.comm.Job;
import org.eurekaclinical.eureka.client.comm.JobFilter;
import org.eurekaclinical.eureka.client.comm.SourceConfig;
import org.eurekaclinical.eureka.client.comm.Statistics;
import org.protempa.PropositionDefinition;

public class EtlClient
extends EurekaClient {
    private static final GenericType<List<Job>> JobListType = new GenericType<List<Job>>(){};
    private static final GenericType<Job> JobType = new GenericType<Job>(){};
    private static final GenericType<Statistics> JobStatsType = new GenericType<Statistics>(){};
    private static final GenericType<List<SourceConfig>> SourceConfigListType = new GenericType<List<SourceConfig>>(){};
    private static final GenericType<List<EtlDestination>> DestinationListType = new GenericType<List<EtlDestination>>(){};
    private static final GenericType<List<EtlCohortDestination>> CohortDestinationListType = new GenericType<List<EtlCohortDestination>>(){};
    private static final GenericType<List<EtlI2B2Destination>> I2B2DestinationListType = new GenericType<List<EtlI2B2Destination>>(){};
    private static final GenericType<List<EtlPatientSetExtractorDestination>> PatientSetExtractorDestinationListType = new GenericType<List<EtlPatientSetExtractorDestination>>(){};
    private static final GenericType<List<EtlPatientSetSenderDestination>> PatientSetSenderDestinationListType = new GenericType<List<EtlPatientSetSenderDestination>>(){};
    private static final GenericType<List<EtlTabularFileDestination>> TabularFileDestinationListType = new GenericType<List<EtlTabularFileDestination>>(){};
    private static final GenericType<List<PropositionDefinition>> PropositionDefinitionList = new GenericType<List<PropositionDefinition>>(){};
    private static final GenericType<List<String>> PropositionSearchResultsList = new GenericType<List<String>>(){};
    private static final GenericType<List<Role>> RoleList = new GenericType<List<Role>>(){};
    private final URI resourceUrl;

    @Inject
    public EtlClient(String inEtlUrl) {
        this.resourceUrl = URI.create(inEtlUrl);
    }

    protected URI getResourceUrl() {
        return this.resourceUrl;
    }

    public List<SourceConfig> getSourceConfigs() throws ClientException {
        String path = "/api/protected/sourceconfigs";
        return (List)this.doGet("/api/protected/sourceconfigs", SourceConfigListType);
    }

    public SourceConfig getSourceConfig(String sourceConfigId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/sourceconfigs/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        return (SourceConfig)this.doGet(path, SourceConfig.class);
    }

    public List<EtlDestination> getDestinations() throws ClientException {
        String path = "/api/protected/destinations";
        return (List)this.doGet("/api/protected/destinations", DestinationListType);
    }

    public List<EtlCohortDestination> getCohortDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.COHORT.name());
        return (List)this.doGet("/api/protected/destinations/", (MultivaluedMap)queryParams, CohortDestinationListType);
    }

    public List<EtlI2B2Destination> getI2B2Destinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.I2B2.name());
        return (List)this.doGet("/api/protected/destinations/", (MultivaluedMap)queryParams, I2B2DestinationListType);
    }

    public List<EtlPatientSetExtractorDestination> getPatientSetExtractorDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.PATIENT_SET_EXTRACTOR.name());
        return (List)this.doGet("/api/protected/destinations/", (MultivaluedMap)queryParams, PatientSetExtractorDestinationListType);
    }

    public List<EtlPatientSetSenderDestination> getPatientSetSenderDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.PATIENT_SET_SENDER.name());
        return (List)this.doGet("/api/protected/destinations/", (MultivaluedMap)queryParams, PatientSetSenderDestinationListType);
    }

    public List<EtlTabularFileDestination> getTabularFileDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.TABULAR_FILE.name());
        return (List)this.doGet("/api/protected/destinations/", (MultivaluedMap)queryParams, TabularFileDestinationListType);
    }

    public EtlDestination getDestination(String destId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{destId}).build(new Object[0]).toString();
        return (EtlDestination)this.doGet(path, EtlDestination.class);
    }

    public Long createDestination(EtlDestination etlDest) throws ClientException {
        String path = "/api/protected/destinations";
        URI destURI = this.doPostCreate(path, etlDest);
        return this.extractId(destURI);
    }

    public void updateDestination(EtlDestination etlDest) throws ClientException {
        String path = "/api/protected/destinations";
        this.doPut(path, etlDest);
    }

    public void deleteDestination(String etlDestId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{etlDestId}).build(new Object[0]).toString();
        this.doDelete(path);
    }

    public Long submitJob(JobRequest inJobRequest) throws ClientException {
        String path = "/api/protected/jobs";
        URI jobUri = this.doPostCreate("/api/protected/jobs", inJobRequest);
        return this.extractId(jobUri);
    }

    public List<Job> getJobStatus(JobFilter inFilter) throws ClientException {
        String path = "/api/protected/jobs/status";
        return (List)this.doGet("/api/protected/jobs/status", JobListType);
    }

    public List<Job> getJobs() throws ClientException {
        String path = "/api/protected/jobs";
        return (List)this.doGet("/api/protected/jobs", JobListType);
    }

    public List<Job> getJobsDesc() throws ClientException {
        String path = "/api/protected/jobs";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"order", (Object)"desc");
        return (List)this.doGet("/api/protected/jobs", (MultivaluedMap)queryParams, JobListType);
    }

    public List<Job> getLatestJob() throws ClientException {
        String path = "/api/protected/jobs/latest";
        return (List)this.doGet("/api/protected/jobs/latest", JobListType);
    }

    public Job getJob(Long inJobId) throws ClientException {
        String path = "/api/protected/jobs/" + inJobId;
        return (Job)this.doGet(path, JobType);
    }

    public Statistics getJobStats(Long inJobId, String inPropId) throws ClientException {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/api/protected/jobs/{arg1}/stats/");
        if (inPropId != null) {
            uriBuilder = uriBuilder.segment(new String[]{inPropId});
        }
        return (Statistics)this.doGet(uriBuilder.build(new Object[]{inJobId}).toString(), JobStatsType);
    }

    public void validatePropositions(ValidationRequest inRequest) throws ClientException {
        String path = "/api/protected/validate";
        this.doPost("/api/protected/validate", inRequest);
    }

    public PropositionDefinition getPropositionDefinition(String sourceConfigId, String inKey) throws ClientException {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)"key", (Object)inKey);
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        List propDefs = (List)this.doPost(path, (MultivaluedMap)formParams, PropositionDefinitionList);
        if (propDefs.isEmpty()) {
            throw new ClientException(ClientResponse.Status.NOT_FOUND, null);
        }
        return (PropositionDefinition)propDefs.get(0);
    }

    public List<PropositionDefinition> getPropositionDefinitions(String sourceConfigId, List<String> inKeys, Boolean withChildren) throws ClientException {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        for (String key : inKeys) {
            formParams.add((Object)"key", (Object)key);
        }
        formParams.add((Object)"withChildren", (Object)withChildren.toString());
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        return (List)this.doPost(path, (MultivaluedMap)formParams, PropositionDefinitionList);
    }

    public void upload(String fileName, String sourceId, String fileTypeId, InputStream inputStream) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/file/upload/").segment(new String[]{sourceId}).segment(new String[]{fileTypeId}).build(new Object[0]).toString();
        FormDataMultiPart part = new FormDataMultiPart();
        part.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(fileName)).build(), (Object)inputStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        this.doPostMultipart(path, part);
    }

    public List<String> getPropositionSearchResults(String sourceConfigId, String inSearchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/search/").segment(new String[]{sourceConfigId}).segment(new String[]{inSearchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, PropositionSearchResultsList);
    }

    public List<PropositionDefinition> getPropositionSearchResultsBySearchKey(String sourceConfigId, String inSearchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/propsearch/").segment(new String[]{sourceConfigId}).segment(new String[]{inSearchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, PropositionDefinitionList);
    }

    public ClientResponse getOutput(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/output/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return this.doGetResponse(path);
    }

    public void deleteOutput(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/output/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        this.doDelete(path);
    }

    public List<Role> getRoles() throws ClientException {
        String path = "/api/protected/roles";
        return (List)this.doGet("/api/protected/roles", RoleList);
    }

    public Role getRole(Long inRoleId) throws ClientException {
        String path = "/api/protected/roles/" + inRoleId;
        return (Role)this.doGet(path, Role.class);
    }

    public Role getRoleByName(String name) throws ClientException {
        return (Role)this.doGet("/api/protected/roles/byname/" + name, Role.class);
    }
}

