/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.comm.clients;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EurekaClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ThresholdsOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueComparator;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.CohortDestination;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.DestinationType;
import org.eurekaclinical.eureka.client.comm.I2B2Destination;
import org.eurekaclinical.eureka.client.comm.Job;
import org.eurekaclinical.eureka.client.comm.JobSpec;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.SourceConfig;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.eureka.client.comm.Statistics;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesClient
extends EurekaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesClient.class);
    private static final GenericType<List<TimeUnit>> TimeUnitList = new GenericType<List<TimeUnit>>(){};
    private static final GenericType<List<FrequencyType>> FrequencyTypeList = new GenericType<List<FrequencyType>>(){};
    private static final GenericType<List<RelationOperator>> RelationOperatorList = new GenericType<List<RelationOperator>>(){};
    private static final GenericType<List<ThresholdsOperator>> ThresholdsOperatorList = new GenericType<List<ThresholdsOperator>>(){};
    private static final GenericType<List<ValueComparator>> ValueComparatorList = new GenericType<List<ValueComparator>>(){};
    private static final GenericType<List<SystemPhenotype>> SystemPhenotypeList = new GenericType<List<SystemPhenotype>>(){};
    private static final GenericType<List<Phenotype>> PhenotypeList = new GenericType<List<Phenotype>>(){};
    private static final GenericType<List<Role>> RoleList = new GenericType<List<Role>>(){};
    private static final GenericType<List<Job>> JobList = new GenericType<List<Job>>(){};
    private static final GenericType<List<SourceConfig>> SourceConfigList = new GenericType<List<SourceConfig>>(){};
    private static final GenericType<List<SourceConfigParams>> SourceConfigParamsList = new GenericType<List<SourceConfigParams>>(){};
    private static final GenericType<List<Destination>> DestinationList = new GenericType<List<Destination>>(){};
    private static final GenericType<List<CohortDestination>> CohortDestinationListType = new GenericType<List<CohortDestination>>(){};
    private static final GenericType<List<I2B2Destination>> I2B2DestinationListType = new GenericType<List<I2B2Destination>>(){};
    private static final GenericType<List<String>> SystemPhenotypeSearchResultsList = new GenericType<List<String>>(){};
    private final String servicesUrl;

    public ServicesClient(String inServicesUrl) {
        LOGGER.info("Using eureka-services URL {}", (Object)inServicesUrl);
        this.servicesUrl = inServicesUrl;
    }

    protected String getResourceUrl() {
        return this.servicesUrl;
    }

    public void verifyUser(String inCode) throws ClientException {
        String path = "/api/userrequests/verify/" + inCode;
        this.doPut(path);
    }

    public List<Role> getRoles() throws ClientException {
        String path = "/api/protected/roles";
        return (List)this.doGet("/api/protected/roles", RoleList);
    }

    public Role getRole(Long inRoleId) throws ClientException {
        String path = "/api/protected/roles/" + inRoleId;
        return (Role)this.doGet(path, Role.class);
    }

    public Role getRoleByName(String name) throws ClientException {
        return (Role)this.doGet("/api/protected/roles/byname/" + name, Role.class);
    }

    public URI submitJob(JobSpec inUpload) throws ClientException {
        String path = "/api/protected/jobs";
        URI jobUrl = this.doPostCreate("/api/protected/jobs", inUpload);
        return jobUrl;
    }

    public void upload(String fileName, String sourceId, String fileTypeId, InputStream inputStream) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/file/upload/").segment(new String[]{sourceId}).segment(new String[]{fileTypeId}).build(new Object[0]).toString();
        this.doPostMultipart(path, fileName, inputStream);
    }

    public Job getJob(Long jobId) throws ClientException {
        String path = "/api/protected/jobs/" + jobId;
        return (Job)this.doGet(path, Job.class);
    }

    public Statistics getJobStats(Long jobId, String propId) throws ClientException {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/api/protected/jobs/{arg1}/stats/");
        if (propId != null) {
            uriBuilder = uriBuilder.segment(new String[]{propId});
        }
        return (Statistics)this.doGet(uriBuilder.build(new Object[]{jobId}).toString(), Statistics.class);
    }

    public List<Job> getJobs() throws ClientException {
        String path = "/api/protected/jobs";
        return (List)this.doGet("/api/protected/jobs", JobList);
    }

    public List<Job> getJobsDesc() throws ClientException {
        String path = "/api/protected/jobs";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"order", (Object)"desc");
        return (List)this.doGet("/api/protected/jobs", JobList, (MultivaluedMap)queryParams);
    }

    public List<Job> getLatestJob() throws ClientException {
        String path = "/api/protected/jobs/latest";
        return (List)this.doGet("/api/protected/jobs/latest", JobList);
    }

    public List<Phenotype> getPhenotypes(String[] inKeys, boolean summarized) throws ClientException {
        ArrayList<Phenotype> result = new ArrayList<Phenotype>();
        if (inKeys != null) {
            ArrayList<String> userPhenotypes = new ArrayList<String>();
            ArrayList<String> systemPhenotypes = new ArrayList<String>();
            for (String key : inKeys) {
                if (key.startsWith("USER:")) {
                    userPhenotypes.add(key);
                    continue;
                }
                systemPhenotypes.add(key);
            }
            if (!userPhenotypes.isEmpty()) {
                for (String userPhenotype : userPhenotypes) {
                    result.add(this.getUserPhenotype(userPhenotype, summarized));
                }
            }
            if (!systemPhenotypes.isEmpty()) {
                result.addAll(this.getSystemPhenotypes(systemPhenotypes, summarized));
            }
        }
        return result;
    }

    public URI proxyPost(String path, String json) throws ClientException {
        return this.doPostCreate(path, json);
    }

    public void proxyDelete(String path) throws ClientException {
        this.doDelete(path);
    }

    public void proxyPut(String path, String json) throws ClientException {
        this.doPut(path, json);
    }

    public String proxyGet(String path, MultivaluedMap queryParams) throws ClientException {
        if (queryParams == null) {
            return this.doGet(path);
        }
        return this.doGet(path, queryParams);
    }

    public List<Phenotype> getUserPhenotypes(boolean summarized) throws ClientException {
        String path = "/api/protected/phenotypes";
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return (List)this.doGet("/api/protected/phenotypes", PhenotypeList, (MultivaluedMap)queryParams);
        }
        return (List)this.doGet("/api/protected/phenotypes", PhenotypeList);
    }

    public Phenotype getUserPhenotype(String inKey, boolean summarized) throws ClientException {
        if (inKey == null) {
            throw new IllegalArgumentException("inKey cannot be null");
        }
        String path = UriBuilder.fromPath((String)"/api/protected/phenotypes/").segment(new String[]{inKey}).build(new Object[0]).toString();
        if (summarized) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            queryParams.add((Object)"summarize", (Object)"true");
            return (Phenotype)this.doGet(path, Phenotype.class, (MultivaluedMap)queryParams);
        }
        return (Phenotype)this.doGet(path, Phenotype.class);
    }

    public URI saveUserPhenotype(Phenotype inPhenotype) throws ClientException {
        String path = "/api/protected/phenotypes";
        URI phenotypeURI = this.doPostCreate("/api/protected/phenotypes", inPhenotype);
        return phenotypeURI;
    }

    public void updateUserPhenotype(Long inId, Phenotype inPhenotype) throws ClientException {
        if (inId == null) {
            throw new IllegalArgumentException("inId cannot be null");
        }
        String path = "/api/protected/phenotypes/" + inId;
        this.doPut(path, inPhenotype);
    }

    public void deleteUserPhenotype(Long inUserId, Long inId) throws ClientException {
        if (inUserId == null) {
            throw new IllegalArgumentException("inUserId cannot be null");
        }
        if (inId == null) {
            throw new IllegalArgumentException("inId cannot be null");
        }
        String path = "/api/protected/phenotypes/" + inId;
        this.doDelete(path);
    }

    public List<SystemPhenotype> getSystemPhenotypes() throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/").build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeList);
    }

    public List<SystemPhenotype> getSystemPhenotypes(List<String> inKeys, boolean summarize) throws ClientException {
        if (inKeys == null) {
            throw new IllegalArgumentException("inKeys cannot be null");
        }
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        for (String key : inKeys) {
            formParams.add((Object)"key", (Object)key);
        }
        formParams.add((Object)"summarize", (Object)Boolean.toString(summarize));
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/").build(new Object[0]).toString();
        return (List)this.doPost(path, SystemPhenotypeList, (MultivaluedMap)formParams);
    }

    public SystemPhenotype getSystemPhenotype(String inKey, boolean summarize) throws ClientException {
        List<SystemPhenotype> result = this.getSystemPhenotypes(Collections.singletonList(inKey), summarize);
        if (result.isEmpty()) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result.get(0);
    }

    public List<TimeUnit> getTimeUnitsAsc() throws ClientException {
        String path = "/api/protected/timeunits";
        return (List)this.doGet("/api/protected/timeunits", TimeUnitList);
    }

    public TimeUnit getTimeUnit(Long inId) throws ClientException {
        String path = "/api/protected/timeunits/" + inId;
        return (TimeUnit)this.doGet(path, TimeUnit.class);
    }

    public TimeUnit getTimeUnitByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/timeunits/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return (TimeUnit)this.doGet(path, TimeUnit.class);
    }

    public List<RelationOperator> getRelationOperatorsAsc() throws ClientException {
        String path = "/api/protected/relationops";
        return (List)this.doGet("/api/protected/relationops", RelationOperatorList);
    }

    public RelationOperator getRelationOperator(Long inId) throws ClientException {
        String path = "/api/protected/relationops/" + inId;
        return (RelationOperator)this.doGet(path, RelationOperator.class);
    }

    public RelationOperator getRelationOperatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/relationops/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return (RelationOperator)this.doGet(path, RelationOperator.class);
    }

    public List<ThresholdsOperator> getThresholdsOperators() throws ClientException {
        String path = "/api/protected/thresholdsops/";
        return (List)this.doGet("/api/protected/thresholdsops/", ThresholdsOperatorList);
    }

    public ThresholdsOperator getThresholdsOperator(Long inId) throws ClientException {
        String path = "/api/protected/thresholdsops/" + inId;
        return (ThresholdsOperator)this.doGet(path, ThresholdsOperator.class);
    }

    public ThresholdsOperator getThresholdsOperatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/thresholdsops/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return (ThresholdsOperator)this.doGet(path, ThresholdsOperator.class);
    }

    public List<ValueComparator> getValueComparatorsAsc() throws ClientException {
        String path = "/api/protected/valuecomps";
        return (List)this.doGet("/api/protected/valuecomps", ValueComparatorList);
    }

    public ValueComparator getValueComparator(Long inId) throws ClientException {
        String path = "/api/protected/valuecomps/" + inId;
        return (ValueComparator)this.doGet(path, ValueComparator.class);
    }

    public ValueComparator getValueComparatorByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/valuecomps/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return (ValueComparator)this.doGet(path, ValueComparator.class);
    }

    public List<FrequencyType> getFrequencyTypesAsc() throws ClientException {
        String path = "/api/protected/frequencytypes";
        return (List)this.doGet("/api/protected/frequencytypes", FrequencyTypeList);
    }

    public List<SourceConfig> getSourceConfigs() throws ClientException {
        String path = "/api/protected/sourceconfig";
        return (List)this.doGet(path, SourceConfigList);
    }

    public SourceConfig getSourceConfig(String sourceConfigId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/sourceconfig/").segment(new String[]{sourceConfigId}).build(new Object[0]).toString();
        return (SourceConfig)this.doGet(path, SourceConfig.class);
    }

    public List<SourceConfigParams> getSourceConfigParams() throws ClientException {
        String path = "/api/protected/sourceconfig/parameters/list";
        return (List)this.doGet(path, SourceConfigParamsList);
    }

    public URI createDestination(Destination destination) throws ClientException {
        String path = "/api/protected/destinations";
        URI destURI = this.doPostCreate(path, destination);
        return destURI;
    }

    public void updateDestination(Destination destination) throws ClientException {
        String path = "/api/protected/destinations";
        this.doPut(path, destination);
    }

    public List<Destination> getDestinations() throws ClientException {
        String path = "/api/protected/destinations";
        return (List)this.doGet(path, DestinationList);
    }

    public List<CohortDestination> getCohortDestinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.COHORT.name());
        return (List)this.doGet("/api/protected/destinations/", CohortDestinationListType, (MultivaluedMap)queryParams);
    }

    public List<I2B2Destination> getI2B2Destinations() throws ClientException {
        String path = "/api/protected/destinations/";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"type", (Object)DestinationType.I2B2.name());
        return (List)this.doGet("/api/protected/destinations/", I2B2DestinationListType, (MultivaluedMap)queryParams);
    }

    public Destination getDestination(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return (Destination)this.doGet(path, Destination.class);
    }

    public void deleteDestination(Long id, String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/destinations/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        this.doDelete(path);
    }

    public List<String> getSystemPhenotypeSearchResults(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/search/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeSearchResultsList);
    }

    public List<SystemPhenotype> getSystemPhenotypeSearchResultsBySearchKey(String searchKey) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/concepts/propsearch/").segment(new String[]{searchKey}).build(new Object[0]).toString();
        return (List)this.doGet(path, SystemPhenotypeList);
    }

    public InputStream getOutput(String destinationId) throws ClientException {
        String path = UriBuilder.fromPath((String)"/api/protected/output/").segment(new String[]{destinationId}).build(new Object[0]).toString();
        return (InputStream)this.doGet(path, InputStream.class);
    }
}

