/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.TabularFileDestinationTableColumnEntity;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="tabular_file_destinations")
public class TabularFileDestinationEntity
extends DestinationEntity {
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="destination")
    private List<TabularFileDestinationTableColumnEntity> tableColumns = new ArrayList<TabularFileDestinationTableColumnEntity>();

    public List<TabularFileDestinationTableColumnEntity> getTableColumns() {
        return new ArrayList<TabularFileDestinationTableColumnEntity>(this.tableColumns);
    }

    public void setTableColumns(List<TabularFileDestinationTableColumnEntity> inTableColumns) {
        if (inTableColumns == null) {
            this.tableColumns = new ArrayList<TabularFileDestinationTableColumnEntity>();
        } else {
            this.tableColumns = new ArrayList<TabularFileDestinationTableColumnEntity>(inTableColumns);
            for (TabularFileDestinationTableColumnEntity tableColumn : this.tableColumns) {
                tableColumn.setDestination(this);
            }
        }
    }

    public void addTableColumn(TabularFileDestinationTableColumnEntity inTableColumn) {
        if (!this.tableColumns.contains(inTableColumn)) {
            this.tableColumns.add(inTableColumn);
            inTableColumn.setDestination(this);
        }
    }

    public void removeTableColumn(TabularFileDestinationTableColumnEntity inTableColumn) {
        if (this.tableColumns.remove(inTableColumn)) {
            inTableColumn.setDestination(null);
        }
    }

    public Character getDelimiter() {
        return Character.valueOf('\t');
    }

    @Override
    public boolean isGetStatisticsSupported() {
        return false;
    }

    @Override
    public boolean isAllowingQueryPropositionIds() {
        return true;
    }

    @Override
    public void accept(DestinationEntityVisitor visitor) {
        visitor.visit(this);
    }
}

