/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.common.entity;

import edu.emory.cci.aiw.cvrg.eureka.common.entity.AuthorizedUserEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.DestinationGroupMembership;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.SourceConfigGroupMembership;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="groups")
public class EtlGroup {
    @Id
    @SequenceGenerator(name="GROUPS_SEQ_GENERATOR", sequenceName="GROUPS_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GROUPS_SEQ_GENERATOR")
    private Long id;
    private String name;
    @ManyToMany(mappedBy="groups")
    private List<AuthorizedUserEntity> users;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="group")
    private List<SourceConfigGroupMembership> sourceConfigs;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="destination")
    private List<DestinationGroupMembership> destinations;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AuthorizedUserEntity> getUsers() {
        return this.users;
    }

    public void setUsers(List<AuthorizedUserEntity> users) {
        this.users = users;
    }

    public List<SourceConfigGroupMembership> getSourceConfigs() {
        return this.sourceConfigs;
    }

    public void setSourceConfigs(List<SourceConfigGroupMembership> sourceConfigs) {
        this.sourceConfigs = sourceConfigs;
    }

    public List<DestinationGroupMembership> getDestinations() {
        return new ArrayList<DestinationGroupMembership>(this.destinations);
    }

    public void setDestinations(List<DestinationGroupMembership> inDestinations) {
        if (inDestinations == null) {
            this.destinations = new ArrayList<DestinationGroupMembership>();
        } else {
            this.destinations = new ArrayList<DestinationGroupMembership>(inDestinations);
            for (DestinationGroupMembership destination : this.destinations) {
                destination.setGroup(this);
            }
        }
    }

    public void addDestination(DestinationGroupMembership inDestination) {
        if (!this.destinations.contains(inDestination)) {
            this.destinations.add(inDestination);
            inDestination.setGroup(this);
        }
    }

    public void removeDestination(DestinationGroupMembership inDestination) {
        if (this.destinations.remove(inDestination)) {
            inDestination.setGroup(null);
        }
    }
}

