/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.tomcat.CasRealm;
import org.jasig.cas.client.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionCasRealmDelegate
implements CasRealm {
    public static final String DEFAULT_ROLE_NAME = "role";
    private String roleAttributeName = "role";

    public void setRoleAttributeName(String name) {
        this.roleAttributeName = name;
    }

    @Override
    public Principal authenticate(Principal p) {
        return p;
    }

    @Override
    public String[] getRoles(Principal p) {
        CommonUtils.assertTrue((boolean)(p instanceof AttributePrincipal), (String)("Expected instance of AttributePrincipal but got " + p.getClass()));
        Collection<String> roles = this.getRoleCollection(p);
        String[] array = new String[roles.size()];
        roles.toArray(array);
        return array;
    }

    @Override
    public boolean hasRole(Principal principal, String role) {
        return this.getRoleCollection(principal).contains(role);
    }

    private Collection<String> getRoleCollection(Principal p) {
        if (!(p instanceof AttributePrincipal)) {
            return Collections.emptyList();
        }
        Object attributes = ((AttributePrincipal)p).getAttributes().get(this.roleAttributeName);
        if (attributes == null) {
            return Collections.emptyList();
        }
        if (attributes instanceof Collection) {
            return (Collection)attributes;
        }
        return Arrays.asList(attributes.toString());
    }
}

