/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.tomcat.CasRealm;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;

public final class AuthenticatorDelegate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String serviceUrl;
    private String serverName;
    private String casServerLoginUrl;
    private String artifactParameterName;
    private String serviceParameterName;
    private TicketValidator ticketValidator;
    private CasRealm realm;

    public final Principal authenticate(HttpServletRequest request, HttpServletResponse response) {
        Principal p;
        Assertion assertion = null;
        HttpSession session = request.getSession();
        if (session != null) {
            assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        }
        if (assertion == null) {
            this.log.debug((Object)"CAS assertion not found in session -- authentication required.");
            String token = request.getParameter(this.artifactParameterName);
            String service = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)this.serviceUrl, (String)this.serverName, (String)this.artifactParameterName, (boolean)true);
            if (CommonUtils.isBlank((String)token)) {
                String redirectUrl = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.serviceParameterName, (String)service, (boolean)false, (boolean)false);
                this.log.debug((Object)("Redirecting to " + redirectUrl));
                CommonUtils.sendRedirect((HttpServletResponse)response, (String)redirectUrl);
                return null;
            }
            try {
                this.log.debug((Object)("Attempting to validate " + token + " for " + service));
                assertion = this.ticketValidator.validate(token, service);
                this.log.debug((Object)"CAS authentication succeeded.");
                if (session == null) {
                    session = request.getSession(true);
                }
                session.setAttribute("_const_cas_assertion_", (Object)assertion);
            }
            catch (TicketValidationException e) {
                this.setUnauthorized(response, e.getMessage());
                return null;
            }
        }
        if ((p = this.realm.authenticate((Principal)assertion.getPrincipal())) == null) {
            this.log.debug((Object)(assertion.getPrincipal().getName() + " failed to authenticate to " + this.realm));
            this.setUnauthorized(response, null);
        }
        return p;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getCasServerLoginUrl() {
        return this.casServerLoginUrl;
    }

    public void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public void setArtifactParameterName(String artifactParameterName) {
        this.artifactParameterName = artifactParameterName;
    }

    public void setServiceParameterName(String serviceParameterName) {
        this.serviceParameterName = serviceParameterName;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public void setRealm(CasRealm realm) {
        this.realm = realm;
    }

    private void setUnauthorized(HttpServletResponse response, String message) {
        try {
            if (message != null) {
                response.sendError(401, message);
            } else {
                response.sendError(401);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error setting 403 status.", e);
        }
    }
}

