/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements OracleClob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize = -1;
    private short csform;
    boolean isFree = false;
    boolean fromObject = false;
    long cachedLengthOfClobInChars = -1L;
    char[] prefetchData = null;
    int prefetchDataSize = 0;
    boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    transient CharacterSet dilCharacterSet = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Mar_12_20:10:49_PDT_2013";
    public static final boolean TRACE = false;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, boolean bl) throws SQLException {
        this(oracleConnection, byArray);
        this.fromObject = bl;
    }

    private static final short getFormOfUseFromLocator(byte[] byArray) {
        int n2 = -1;
        if (byArray != null && byArray.length > 5) {
            n2 = (byArray[5] & 0x40) != 0 && (byArray[5] & 0xFFFFFF80) == 0 ? 2 : 1;
        }
        return (short)n2;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = CLOB.getFormOfUseFromLocator(byArray);
        }
        CLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = ((OracleConnection)oracleConnection).createClobDBAccess();
        this.dbaccess.incrementTempLobReferenceCount(byArray);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        short s3 = CLOB.getFormOfUseFromLocator(byArray);
        if (s3 != -1) {
            if (s2 != s3) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.csform = s3;
        } else {
            this.csform = s2;
        }
    }

    @Override
    public boolean isNCLOB() {
        return this.csform == 2;
    }

    @Override
    public long length() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l2 = -1L;
        l2 = this.activePrefetch && this.cachedLengthOfClobInChars != -1L ? this.cachedLengthOfClobInChars : (this.canReadBasicLobDataInLocator() ? (long)this.dilGetChars().length : this.getDBAccess().length(this));
        return l2;
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 0 || l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetSubString(l2, n2);
        }
        String string = null;
        if (n2 == 0 || this.activePrefetch && (this.cachedLengthOfClobInChars == 0L || this.cachedLengthOfClobInChars > 0L && l2 - 1L >= this.cachedLengthOfClobInChars)) {
            string = new String();
        } else if (this.prefetchData != null && this.prefetchDataSize > 0 && this.cachedLengthOfClobInChars == (long)this.prefetchDataSize && l2 + (long)n2 - 1L <= this.cachedLengthOfClobInChars) {
            string = new String(this.prefetchData, (int)l2 - 1, n2);
        } else {
            char[] cArray = this.getDBAccess().getCharBufferSync(n2);
            int n3 = this.getChars(l2, n2, cArray);
            string = n3 > 0 ? new String(cArray, 0, n3) : new String();
            this.getDBAccess().cacheBufferSync(cArray);
        }
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(1L);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(1L);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, string, l2);
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, (CLOB)clob, l2);
    }

    @Override
    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().getChars(this, l2, n2, cArray);
    }

    @Override
    public Writer getCharacterOutputStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setCharacterStream(1L);
    }

    @Override
    public OutputStream getAsciiOutputStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setAsciiStream(1L);
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    @Override
    public int putChars(long l2, char[] cArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, cArray != null ? cArray.length : 0);
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, n2);
    }

    @Override
    public int putChars(long l2, char[] cArray, int n2, int n3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, n2, n3);
    }

    @Override
    public int putString(long l2, String string) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setString(l2, string);
    }

    @Override
    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    @Override
    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.getChunkSize();
        int n3 = 0;
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return bl;
    }

    @Override
    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, false);
    }

    @Override
    public Writer getCharacterOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2, false);
    }

    @Override
    public InputStream getAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                l2 = 1L;
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(l2);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    @Override
    public Reader getCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                l2 = 1L;
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(l2);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), l2);
    }

    @Override
    public void trim(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.truncate(l2);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        return CLOB.createTemporary(connection, bl, n2, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n3, s2);
        cLOB.csform = CLOB.getFormOfUseFromLocator(cLOB.shareBytes());
        return cLOB;
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.getDBAccess().decrementTempLobReferenceCount(this.shareBytes());
        if (n2 == 0) {
            this.getDBAccess().freeTemporary(this, this.fromObject);
        }
    }

    @Override
    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isTemporary(this);
    }

    @Override
    public void open(LargeObjectAccessMode largeObjectAccessMode) throws SQLException {
        this.open(largeObjectAccessMode.getCode());
    }

    public void open(int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().open(this, n2);
    }

    @Override
    public void close() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().close(this);
    }

    @Override
    public boolean isOpen() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isOpen(this);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = 0;
        if (string != null && string.length() != 0) {
            n2 = this.putChars(l2, string.toCharArray());
        }
        return n2;
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 + n3 > string.length()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = 0;
        if (string != null && string.length() != 0) {
            n4 = this.putChars(l2, string.toCharArray(), n2, n3);
        }
        return n4;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, true);
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2, true);
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().trim(this, l2);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public String stringValue() throws SQLException {
        Reader reader = this.getCharacterStream();
        int n2 = this.getBufferSize();
        int n3 = 0;
        StringWriter stringWriter = new StringWriter(n2);
        char[] cArray = new char[n2];
        try {
            while ((n3 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return stringWriter.getBuffer().substring(0);
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new CLOB[n2];
    }

    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long l2) {
        this.cachedLengthOfClobInChars = l2;
    }

    @Override
    public final void setChunkSize(int n2) {
        this.dbChunkSize = n2;
    }

    @Override
    public final void setPrefetchedData(char[] cArray) {
        if (cArray == null) {
            this.setPrefetchedData(null, 0);
        } else {
            this.setPrefetchedData(cArray, cArray.length);
        }
    }

    @Override
    public final void setPrefetchedData(char[] cArray, int n2) {
        this.prefetchData = cArray;
        this.prefetchDataSize = n2;
    }

    @Override
    public final char[] getPrefetchedData() {
        return this.prefetchData;
    }

    @Override
    public final int getPrefetchedDataSize() {
        return this.prefetchDataSize;
    }

    @Override
    public final void setActivePrefetch(boolean bl) {
        if (this.activePrefetch && !bl) {
            this.clearCachedData();
        }
        this.activePrefetch = bl;
    }

    @Override
    public final void clearCachedData() {
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    boolean canReadBasicLobDataInLocator() throws SQLException {
        int n2;
        byte[] byArray = this.shareBytes();
        if (byArray == null || byArray.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int n3 = byArray[6] & 0xFF;
        int n4 = byArray[7] & 0xFF;
        boolean bl = (n3 & 8) == 8;
        boolean bl2 = (n4 & 0xFFFFFF80) == -128;
        boolean bl3 = false;
        if (bl && !bl2) {
            n2 = byArray[88] & 0xFF;
            bl3 = (n2 & 8) == 8;
        }
        n2 = bl && !bl2 && bl3 ? 1 : 0;
        boolean bl4 = false;
        if (n2 != 0) {
            this.dilGetCharacterSet();
            bl4 = !this.dilCharacterSet.isUnknown();
        }
        return bl4;
    }

    int dilGetCharSetId() throws SQLException {
        byte by = this.shareBytes()[32];
        byte by2 = this.shareBytes()[33];
        int n2 = (by & 0xFF) << 8 | by2 & 0xFF;
        return n2;
    }

    boolean isMigratedAL16UTF16LE() {
        int n2 = this.shareBytes()[7] & 0xFF;
        return (n2 & 0x40) == 64;
    }

    boolean isVariableWidth() {
        int n2;
        int n3 = this.shareBytes()[6] & 0xFF;
        return (n3 & (n2 = 128)) == n2;
    }

    void dilGetCharacterSet() throws SQLException {
        if (this.dilCharacterSet == null) {
            if (this.isMigratedAL16UTF16LE()) {
                this.dilCharacterSet = CharacterSet.make(2002);
            } else if (this.isVariableWidth()) {
                this.dilCharacterSet = CharacterSet.make(2000);
            } else {
                int n2 = this.dilGetCharSetId();
                this.dilCharacterSet = CharacterSet.make(n2);
            }
        }
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    char[] dilGetChars() throws SQLException {
        int n2 = this.dilLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(this.shareBytes(), 102, byArray, 0, n2);
        String string = this.dilCharacterSet.toStringWithReplacement(byArray, 0, n2);
        char[] cArray = string.toCharArray();
        return cArray;
    }

    InputStream dilGetAsciiStream(long l2) throws SQLException {
        byte[] byArray;
        char[] cArray = this.dilGetChars();
        if (l2 - 1L > (long)cArray.length) {
            byte[] byArray2 = new byte[]{};
            return new ByteArrayInputStream(byArray2);
        }
        if (this.dilGetCharSetId() == 1) {
            byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
        } else {
            CharacterSet characterSet = CharacterSet.make(1);
            byArray = characterSet.convertWithReplacement(new String(cArray));
        }
        return new ByteArrayInputStream(byArray);
    }

    Reader dilGetCharacterStream(long l2) throws SQLException {
        char[] cArray = this.dilGetChars();
        int n2 = cArray.length;
        if (l2 - 1L > (long)n2) {
            char[] cArray2 = new char[]{};
            return new CharArrayReader(cArray2);
        }
        return new CharArrayReader(cArray, (int)(l2 - 1L), Integer.MAX_VALUE);
    }

    String dilGetSubString(long l2, int n2) throws SQLException {
        char[] cArray = this.dilGetChars();
        if ((int)l2 > cArray.length) {
            return "";
        }
        int n3 = (int)Math.min((long)n2, (long)cArray.length - (l2 - 1L));
        if (n3 == 0) {
            return "";
        }
        return new String(cArray, (int)(l2 - 1L), n3);
    }

    @Override
    public void free() throws SQLException {
        if (this.isFree) {
            return;
        }
        if (this.isOpen()) {
            this.close();
        }
        if (this.isTemporary()) {
            this.freeTemporary();
        }
        this.isFree = true;
        this.dbaccess = null;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                l2 = 1L;
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(l2, l3);
        }
        long l4 = this.length();
        if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newReader(this, this.getChunkSize(), l2, l3);
    }

    Reader dilGetCharacterStream(long l2, long l3) throws SQLException {
        if (l2 < 1L || l3 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        char[] cArray = this.dilGetChars();
        long l4 = cArray.length;
        if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new CharArrayReader(cArray, (int)(l2 - 1L), (int)l3);
    }
}

